/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IndexInfo {
    private final List<Property> props;
    private final Map<String, Boolean> index;

    public IndexInfo(Property ... properties) {
        this(Arrays.asList(properties));
    }

    public IndexInfo(List<Property> props) {
        this.props = props;
        this.index = props.stream().collect(Collectors.toMap(x -> ((Property)x).prop, x -> ((Property)x).indexed));
    }

    public static IndexInfo everythingOk(List<String> properties) {
        return new IndexInfo(properties.stream().map(x -> new Property((String)x, true)).collect(Collectors.toList()));
    }

    public boolean firstIndexed() {
        return this.props.size() > 0 && this.props.get(0).indexed;
    }

    public boolean fullIndexed() {
        return this.props.stream().allMatch(x -> ((Property)x).indexed);
    }

    public List<String> unindexed() {
        return this.props.stream().filter(x -> !((Property)x).indexed).map(x -> ((Property)x).prop).collect(Collectors.toList());
    }

    public boolean hasIndex(String prop) {
        return Boolean.TRUE.equals(this.index.get(prop));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfo indexInfo = (IndexInfo)o;
        return Objects.equals(this.props, indexInfo.props);
    }

    public int hashCode() {
        return Objects.hash(this.props);
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.props);
    }

    public static class Property {
        private final String prop;
        private final boolean indexed;

        public Property(String prop, boolean indexed) {
            this.prop = prop;
            this.indexed = indexed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return this.indexed == property.indexed && Objects.equals(this.prop, property.prop);
        }

        public int hashCode() {
            return Objects.hash(this.prop, this.indexed);
        }

        public String toString() {
            return this.prop + ":" + (this.indexed ? 1 : 0);
        }
    }
}

