/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.intelie.live.Alias;
import net.intelie.live.EntityList;
import net.intelie.live.Specification;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.LikeExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.DistinctRootEntityResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class InnerSpecification<T>
implements Specification<T> {
    private final Class<T> type;
    private final Criterion criterion;
    private final Integer page;
    private final boolean diffOnly;
    private final Iterable<Order> order;
    private final Iterable<Alias> aliases;
    private final Iterable<String> sortProperties;
    private final Iterable<String> fetchProperties;
    private Integer pageSize = 15;

    public InnerSpecification(Class<T> type) {
        this(type, (Criterion)Restrictions.disjunction(), null, null, true, new LinkedList<Alias>(), new LinkedList<Order>(), new LinkedList<String>(), new LinkedList<String>());
    }

    protected InnerSpecification(Class<T> type, Criterion criterion, Integer page, Integer pageSize, boolean diffOnly, Iterable<Alias> aliases, Iterable<Order> order, Iterable<String> sortProperties, Iterable<String> fetchProperties) {
        this.type = type;
        this.criterion = criterion;
        this.page = page;
        this.diffOnly = diffOnly;
        this.order = order;
        this.aliases = aliases;
        this.sortProperties = sortProperties;
        this.fetchProperties = fetchProperties;
        if (pageSize != null) {
            this.pageSize = pageSize;
        }
    }

    public InnerSpecification<T> whereLike(String value, String ... properties) {
        return this.where((Criterion)InnerSpecification.disjunction(value, properties));
    }

    private static Junction disjunction(String value, String[] properties) {
        Disjunction junction = Restrictions.disjunction();
        for (String property : properties) {
            junction.add((Criterion)new LikeExpr(property, value));
        }
        return junction;
    }

    public InnerSpecification<T> orderBy(String ... properties) {
        ArrayList<Order> order = new ArrayList<Order>();
        for (String property : properties) {
            order.add(Order.asc((String)property).nulls(NullPrecedence.FIRST));
        }
        return new InnerSpecification<T>(this.type, this.criterion, this.page, this.pageSize, this.diffOnly, this.aliases, Iterables.concat(this.order, order), Iterables.concat(this.sortProperties, Arrays.asList(properties)), this.fetchProperties);
    }

    public InnerSpecification<T> orderByDescending(String ... properties) {
        ArrayList<Order> order = new ArrayList<Order>();
        for (String property : properties) {
            order.add(Order.desc((String)property).nulls(NullPrecedence.LAST));
        }
        return new InnerSpecification<T>(this.type, this.criterion, this.page, this.pageSize, this.diffOnly, this.aliases, Iterables.concat(this.order, order), Iterables.concat(this.sortProperties, Arrays.asList(properties)), this.fetchProperties);
    }

    public InnerSpecification<T> where(Criterion criterion) {
        return new InnerSpecification<T>(this.type, (Criterion)Restrictions.and((Criterion)this.criterion, (Criterion)criterion), this.page, this.pageSize, this.diffOnly, this.aliases, this.order, this.sortProperties, this.fetchProperties);
    }

    public InnerSpecification<T> createAlias(Alias alias) {
        return new InnerSpecification<T>(this.type, this.criterion, this.page, this.pageSize, this.diffOnly, Iterables.concat(this.aliases, (Iterable)Lists.newArrayList((Object[])new Alias[]{alias})), this.order, this.sortProperties, this.fetchProperties);
    }

    public InnerSpecification<T> page(Integer page) {
        return new InnerSpecification<T>(this.type, this.criterion, page, this.pageSize, this.diffOnly, this.aliases, this.order, this.sortProperties, this.fetchProperties);
    }

    public InnerSpecification<T> pageSize(Integer pageSize) {
        return new InnerSpecification<T>(this.type, this.criterion, this.page, pageSize, this.diffOnly, this.aliases, this.order, this.sortProperties, this.fetchProperties);
    }

    public InnerSpecification<T> fetch(String fetchProperties) {
        return new InnerSpecification<T>(this.type, this.criterion, this.page, this.pageSize, this.diffOnly, this.aliases, this.order, this.sortProperties, Iterables.concat(this.fetchProperties, Collections.singletonList(fetchProperties)));
    }

    public InnerSpecification<T> diffOnly(boolean diffOnly) {
        return new InnerSpecification<T>(this.type, this.criterion, this.page, this.pageSize, diffOnly, this.aliases, this.order, this.sortProperties, this.fetchProperties);
    }

    @Override
    public EntityList<T> all(Session session) {
        Criteria results = this.prepareResults(session, this.pageSize);
        if (this.page != null) {
            Criteria count = this.prepareCount(session);
            return new EntityList(results.list(), (Long)count.uniqueResult(), this.page, this.pageSize, this.order);
        }
        return new EntityList(results.list());
    }

    private Criteria prepareCount(Session session) {
        Criteria criteria = this.prepareAliased(session);
        criteria = criteria.setResultTransformer((ResultTransformer)DistinctRootEntityResultTransformer.INSTANCE).setProjection(Projections.rowCount());
        return criteria;
    }

    private Criteria prepareAliased(Session session) {
        Criteria criteria = session.createCriteria(this.type, "__root").add(this.criterion);
        for (Alias alias : this.aliases) {
            criteria = criteria.createAlias(alias.getAssociationPath(), alias.getAlias(), alias.getJoinType(), alias.getWithClause());
        }
        return criteria;
    }

    private Criteria prepareResults(Session session, int fetch) {
        List<Serializable> ids;
        Criteria results = this.prepareOrdered(session);
        results = this.page == null ? results.setResultTransformer((ResultTransformer)DistinctRootEntityResultTransformer.INSTANCE) : (!(ids = this.prepareIds(session, fetch)).isEmpty() ? results.add(Restrictions.in((String)"id", ids)) : results.add(Restrictions.not((Criterion)Restrictions.conjunction())));
        for (String fetchProperty : this.fetchProperties) {
            results = results.setFetchMode(fetchProperty, FetchMode.JOIN);
        }
        return results;
    }

    private List<Serializable> prepareIds(Session session, int fetch) {
        Criteria idsCriteria = this.prepareOrdered(session);
        if (!Iterables.isEmpty(this.order)) {
            idsCriteria = idsCriteria.addOrder(Order.desc((String)"id"));
        }
        ProjectionList projectionList = Projections.projectionList().add(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.id())));
        for (String property : this.sortProperties) {
            projectionList.add((Projection)Projections.property((String)property));
        }
        idsCriteria = idsCriteria.setProjection((Projection)projectionList);
        int firstResult = (this.page - 1) * fetch;
        int maxResults = fetch;
        if (!this.diffOnly) {
            firstResult = 0;
            maxResults = this.page * fetch;
        }
        Criteria uniques = idsCriteria.setFirstResult(firstResult).setMaxResults(maxResults);
        List list = uniques.list();
        ArrayList ids = Lists.newArrayList();
        for (Object entry : list) {
            Serializable id = entry.getClass().isArray() ? (Serializable)((Object[])entry)[0] : (Serializable)entry;
            ids.add(id);
        }
        return ids;
    }

    private Criteria prepareOrdered(Session session) {
        Criteria results = this.prepareAliased(session);
        for (Order oneOrder : this.order) {
            results = results.addOrder(oneOrder);
        }
        return results;
    }

    public Class<T> type() {
        return this.type;
    }

    @Override
    public T one(Session session) {
        Criteria criteria = this.prepareResults(session, 1);
        criteria = criteria.setMaxResults(1);
        return (T)Iterables.getFirst((Iterable)criteria.list(), null);
    }

    @Override
    public long count(Session session) {
        return (Long)this.prepareCount(session).uniqueResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InnerSpecification)) {
            return false;
        }
        InnerSpecification that = (InnerSpecification)o;
        return Objects.equal((Object)String.valueOf(this.criterion), (Object)String.valueOf(that.criterion)) && Objects.equal(this.criterion.getClass(), that.criterion.getClass()) && Iterables.elementsEqual(this.aliases, that.aliases) && Objects.equal((Object)this.page, (Object)that.page) && Objects.equal((Object)this.pageSize, (Object)that.pageSize) && Objects.equal((Object)this.diffOnly, (Object)that.diffOnly) && Objects.equal((Object)Iterables.toString(this.order), (Object)Iterables.toString(that.order)) && Objects.equal(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.criterion.toString(), this.criterion.getClass(), Lists.newArrayList(this.aliases), this.page, this.pageSize, this.diffOnly, Iterables.toString(this.order), this.type});
    }

    public String toString() {
        return String.format((Locale)null, "%s: %s -> order by %s page %d of size %d", this.type.getSimpleName(), this.criterion, this.order, this.page, this.pageSize);
    }

    public static class LikeExpr
    extends LikeExpression {
        private final String property;
        private final String value;

        public LikeExpr(String property, String value) {
            super(property, value, MatchMode.ANYWHERE, null, true);
            this.property = property;
            this.value = value;
        }

        public String toString() {
            return this.property + " like %" + this.value + "%";
        }
    }
}

