/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.intelie.live.Event;
import net.intelie.live.EventIterator;
import net.intelie.live.LiveJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEventIterator
implements EventIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListEventIterator.class);
    private final Iterator<Event> it;
    private final int total;
    private Event current;

    public ListEventIterator(Event ... events) {
        this(Arrays.asList(events));
    }

    public ListEventIterator(List<Event> it) {
        this(it.iterator(), it.size());
    }

    public ListEventIterator(Iterator<Event> it, int total) {
        this.it = it;
        this.total = total;
    }

    public static long estimateFor(Event event) {
        try {
            if (event != null) {
                return LiveJson.toJson(event).length();
            }
            return 0L;
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    @Override
    public boolean moveNext() {
        this.current = null;
        if (!this.it.hasNext()) {
            return false;
        }
        this.current = this.it.next();
        return true;
    }

    @Override
    public long estimateBytes() {
        return ListEventIterator.estimateFor(this.current);
    }

    @Override
    public Event current() {
        return this.current;
    }

    @Override
    public int count() {
        return this.total;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean delete() {
        try {
            this.it.remove();
            return true;
        }
        catch (Throwable e) {
            LOGGER.debug("Error deleting event", e);
            return false;
        }
    }
}

