/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class LiveJson {
    private static volatile Gson gson;

    public static void reset() {
        gson = LiveJson.create();
    }

    public static Gson create() {
        return LiveJson.builder().create();
    }

    public static GsonBuilder builder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Class.class, (Object)new ClassSerializer());
        builder.registerTypeAdapter(Exception.class, (Object)new ExceptionSerializer());
        builder.registerTypeAdapter(Double.class, (Object)new DoubleSerializer());
        builder.registerTypeAdapter(Float.class, (Object)new FloatSerializer());
        return builder;
    }

    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }

    public static String toJson(JsonElement element) {
        return gson.toJson(element);
    }

    public static JsonElement toJsonTree(Object obj) {
        return gson.toJsonTree(obj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public static <T> T fromJson(JsonElement element, Class<T> clazz) {
        return (T)gson.fromJson(element, clazz);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return (T)gson.fromJson(json, typeOfT);
    }

    public static <T> T fromJson(JsonElement element, Type typeOfT) {
        return (T)gson.fromJson(element, typeOfT);
    }

    static {
        LiveJson.reset();
    }

    private static class FloatSerializer
    extends TypeAdapter<Number> {
        private FloatSerializer() {
        }

        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)in.nextDouble());
        }

        public void write(JsonWriter out, Number value) throws IOException {
            if (value == null || Double.isNaN(value.doubleValue()) || Double.isInfinite(value.doubleValue())) {
                out.nullValue();
            } else {
                out.value(value);
            }
        }
    }

    private static class DoubleSerializer
    extends TypeAdapter<Number> {
        private DoubleSerializer() {
        }

        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextDouble();
        }

        public void write(JsonWriter out, Number value) throws IOException {
            if (value == null || Double.isNaN(value.doubleValue()) || Double.isInfinite(value.doubleValue())) {
                out.nullValue();
            } else {
                out.value(value);
            }
        }
    }

    private static class ExceptionSerializer
    extends TypeAdapter<Exception> {
        private ExceptionSerializer() {
        }

        public void write(JsonWriter out, Exception value) throws IOException {
            if (value != null) {
                out.value(value.getMessage());
            } else {
                out.nullValue();
            }
        }

        public Exception read(JsonReader in) throws IOException {
            in.skipValue();
            return null;
        }
    }

    private static class ClassSerializer
    extends TypeAdapter<Class<?>> {
        private ClassSerializer() {
        }

        public void write(JsonWriter out, Class<?> value) throws IOException {
            if (value != null) {
                out.value(value.getName());
            } else {
                out.nullValue();
            }
        }

        public Class<?> read(JsonReader in) throws IOException {
            try {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Class.forName(in.nextString());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

