/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.intelie.live.StartInfo;
import net.intelie.live.StorageQuery;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.SpanAnnotations;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.Type;

public class LocalQueryMetadata {
    private final StartInfo start;
    private final List<StorageQuery> queries;
    private final Long weight;
    private final Filter declaredFilter;
    private final Set<Period> outputPeriods;
    private final TimeSpan span;
    private final HashMap<String, Object> cache;

    public LocalQueryMetadata(TimeSpan span, StartInfo start, List<StorageQuery> queries, Long weight, Filter declaredFilter, Set<Period> outputPeriods) {
        this.span = span;
        this.start = start;
        this.queries = queries;
        this.weight = weight;
        this.declaredFilter = declaredFilter;
        this.outputPeriods = outputPeriods;
        this.cache = this.buildCache(span, start, queries);
    }

    private HashMap<String, Object> buildCache(TimeSpan span, StartInfo start, List<StorageQuery> queries) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SpanAnnotations annotations = span.annotations();
        for (String key : annotations.keys()) {
            map.put(key, annotations.get(key));
        }
        if (start != null && start.info() != null) {
            map.putAll(start.info());
        }
        for (StorageQuery query : queries) {
            map.putAll(query.extra());
        }
        return map;
    }

    public Filter declaredFilter() {
        return this.declaredFilter;
    }

    public Set<Period> outputPeriods() {
        return this.outputPeriods;
    }

    public TimeSpan span() {
        return this.span;
    }

    public StartInfo start() {
        return this.start;
    }

    public List<StorageQuery> queries() {
        return this.queries;
    }

    public Long weight() {
        return this.weight;
    }

    private boolean isTrue(String key) {
        return Boolean.TRUE.equals(Type.BOOLEAN.cast(this.cache.get(key)));
    }

    public Object getMeta(String key) {
        return this.cache.get(key);
    }

    public String getString(String key) {
        return Type.STRING.cast(this.cache.get(key));
    }

    public Integer getInteger(String key) {
        Double n = Type.NUMBER.cast(this.cache.get(key));
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public boolean simulatedRealTime() {
        return !this.forceRealTime() && (this.isTrue("storage") || !this.span.includesPresent() || this.allowFutureSpan());
    }

    public boolean allowFutureSpan() {
        return this.isTrue("future") || this.isTrue("allowFuture") || this.span.isFixed();
    }

    public boolean disableLatestOptimization() {
        return this.isTrue("disableLatestOptimization");
    }

    public boolean disableRealTime() {
        return !this.forceRealTime() && (this.isTrue("disableRealTime") || this.span.isFixed());
    }

    public boolean forceRealTime() {
        return this.isTrue("forceRealTime");
    }

    public boolean disablePreload() {
        return this.isTrue("disablePreload");
    }

    public boolean truncateCollection() {
        return this.isTrue("truncate");
    }

    public boolean lazy() {
        return this.isTrue("lazy");
    }

    public String extendHistory() {
        return this.getString("extendhistory");
    }

    public String extendFuture() {
        return this.getString("extendfuture");
    }

    public Integer partial() {
        return this.getInteger("partial");
    }
}

