/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.intelie.live.Callback;
import net.intelie.live.SettingsOptions;
import net.intelie.live.SettingsProvider;
import net.intelie.live.util.PathUtils;

public class MemorySettingsProvider
implements SettingsProvider {
    private final TreeMap<Integer, TreeMap<String, String>> data = new TreeMap();
    private final TreeSet<String> keys = new TreeSet();

    @Override
    public synchronized String get(String path) {
        TreeMap<String, String> level = this.data.get(PathUtils.level(path));
        if (level == null) {
            return null;
        }
        if (!level.containsKey(path)) {
            return null;
        }
        return String.valueOf(level.get(path));
    }

    @Override
    public Set<String> checkPaths(Set<String> paths) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        for (String path : paths) {
            TreeMap<String, String> level = this.data.get(PathUtils.level(path));
            if (level != null && level.containsKey(path)) continue;
            list.add(path);
        }
        return list;
    }

    @Override
    public synchronized List<SettingsProvider.Holder> getChildren(String path, int levels) {
        ArrayList<SettingsProvider.Holder> list = new ArrayList<SettingsProvider.Holder>();
        int initialLevel = PathUtils.level(path) + 1;
        for (Map.Entry<Integer, TreeMap<String, String>> entry : this.data.subMap(initialLevel, initialLevel + levels).entrySet()) {
            TreeMap<String, String> level = entry.getValue();
            for (Map.Entry<String, String> subEntry : level.tailMap(path).entrySet()) {
                if (!subEntry.getKey().startsWith(path)) break;
                list.add(new SettingsProvider.Holder(subEntry.getKey(), subEntry.getValue()));
            }
        }
        return list;
    }

    @Override
    public synchronized void set(String path, String content) {
        this.getAndSet(path, content);
    }

    public synchronized String getAndSet(String path, String content) {
        int pathLevel = PathUtils.level(path);
        TreeMap level = this.data.computeIfAbsent(pathLevel, k -> new TreeMap());
        boolean contained = level.containsKey(path);
        String old = level.put(path, content);
        this.keys.add(path);
        if (!contained) {
            return null;
        }
        return String.valueOf(old);
    }

    @Override
    public synchronized void delete(String path) {
        String key;
        Iterator iterator = this.keys.tailSet(path).iterator();
        while (iterator.hasNext() && (key = (String)iterator.next()).startsWith(path)) {
            this.data.get(PathUtils.level(key)).remove(key);
            iterator.remove();
        }
    }

    public synchronized String deleteSingle(String path) {
        this.keys.remove(path);
        TreeMap<String, String> level = this.data.get(PathUtils.level(path));
        if (level != null && level.containsKey(path)) {
            return String.valueOf(level.remove(path));
        }
        return null;
    }

    @Override
    public synchronized <T, E extends Throwable> T transact(SettingsOptions options, String path, Callback<T, E> callback) throws E {
        return callback.call();
    }

    public void clear() {
        this.keys.clear();
        this.data.clear();
    }
}

