/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import net.intelie.live.Event;
import net.intelie.live.EventIterator;
import net.intelie.live.util.AutoList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEventIterator
implements EventIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiEventIterator.class);
    private static final Comparator<EventIterator> COMPARATOR = Comparator.comparing(EventIterator::current);
    private final PriorityQueue<EventIterator> queue;
    private int count;
    private EventIterator currentIt;

    public MultiEventIterator(EventIterator ... enums) {
        this(Arrays.asList(enums));
    }

    public MultiEventIterator(boolean reversed, EventIterator ... enums) {
        this(reversed, Arrays.asList(enums));
    }

    public MultiEventIterator(List<? extends EventIterator> enums) {
        this(false, enums);
    }

    public MultiEventIterator(boolean reversed, List<? extends EventIterator> enums) {
        try (AutoList<? extends EventIterator> auto = new AutoList<EventIterator>(enums);){
            this.queue = new PriorityQueue<EventIterator>(4, reversed ? COMPARATOR.reversed() : COMPARATOR);
            for (EventIterator eventIterator : enums) {
                this.tryAdvance(eventIterator);
                this.count += eventIterator.count();
            }
            auto.release();
        }
    }

    private static void tryClose(EventIterator anEnum) {
        try {
            if (anEnum != null) {
                anEnum.close();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error closing storage enum: {}", (Object)e.getMessage());
            LOGGER.debug("Stacktrace", (Throwable)e);
        }
    }

    @Override
    public boolean moveNext() {
        if (this.currentIt != null) {
            int before = this.currentIt.count();
            this.tryAdvance(this.currentIt);
            this.count += this.currentIt.count() - before;
        }
        this.currentIt = null;
        if (this.queue.isEmpty()) {
            return false;
        }
        this.currentIt = this.queue.poll();
        return true;
    }

    @Override
    public boolean cacheRead() {
        return this.currentIt != null && this.currentIt.cacheRead();
    }

    @Override
    public boolean cacheWrite() {
        return this.currentIt != null && this.currentIt.cacheWrite();
    }

    private void tryAdvance(EventIterator anEnum) {
        try {
            if (anEnum.moveNext()) {
                this.queue.add(anEnum);
            } else {
                MultiEventIterator.tryClose(anEnum);
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public boolean delete() {
        return this.currentIt != null && this.currentIt.delete();
    }

    @Override
    public long estimateBytes() {
        return this.currentIt != null ? this.currentIt.estimateBytes() : 0L;
    }

    @Override
    public Event current() {
        if (this.currentIt == null) {
            return null;
        }
        return this.currentIt.current();
    }

    public EventIterator currentIterator() {
        return this.currentIt;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void close() {
        MultiEventIterator.tryClose(this.currentIt);
        this.currentIt = null;
        while (!this.queue.isEmpty()) {
            MultiEventIterator.tryClose(this.queue.poll());
        }
    }
}

