/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class PermissionDetails {
    private final String name;
    private final Map<String, String> descriptions = new LinkedHashMap<String, String>();

    public PermissionDetails(String name, String description) {
        this.name = name.toLowerCase(Locale.ROOT);
        this.descriptions.put("en_us", description);
    }

    public void addDescription(String locale, String description) {
        Preconditions.checkArgument((locale != null ? 1 : 0) != 0);
        this.descriptions.put(locale.toLowerCase(Locale.ROOT), description);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDetails that = (PermissionDetails)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

