/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.intelie.live.QueryListener;
import net.intelie.live.model.Datasource;

public class Query
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final String description;
    private final String provider;
    private final String expression;
    private final String prefilter;
    private final String reduceHistory;
    private final boolean follow;
    private final String span;
    private final boolean enforceDependencies;
    private final boolean preloadWindow;
    private final Map<String, List<String>> lookupValues;
    private final transient QueryListener listener;
    private final Object source;
    private final boolean forceSyncListener;

    public Query(String expression) {
        this(null, expression);
    }

    public Query(String provider, String expression) {
        this(provider, expression, null, null, null, false, false, false, null, null, Collections.emptyMap(), null, false);
    }

    private Query(String provider, String expression, String prefilter, QueryListener listener, String span, boolean enforceDependencies, boolean follow, boolean preloadWindow, String reduceHistory, String description, Map<String, List<String>> lookupValues, Object source, boolean forceSyncListener) {
        this.forceSyncListener = forceSyncListener;
        if (provider == null) {
            provider = "pipes";
        }
        this.provider = provider;
        this.expression = expression;
        this.prefilter = prefilter;
        this.listener = listener;
        this.span = span;
        this.follow = follow;
        this.enforceDependencies = enforceDependencies;
        this.reduceHistory = reduceHistory;
        this.description = description;
        this.preloadWindow = preloadWindow;
        this.lookupValues = lookupValues;
        this.source = source;
    }

    public Query listenWith(QueryListener listener) {
        return new Query(this.provider, this.expression, this.prefilter, listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query enforceDependencies() {
        return this.enforceDependencies(true);
    }

    public Query enforceDependencies(boolean enforceDependencies) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query span(String span) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query prefilter(String prefilter) {
        return new Query(this.provider, this.expression, prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    @Deprecated
    public Query trackSkipRealtime() {
        return this;
    }

    @Deprecated
    public Query trackSkipRealtime(boolean trackSkipRealtime) {
        return this;
    }

    public Query forceSyncListener() {
        return this.forceSyncListener(true);
    }

    private Query forceSyncListener(boolean forceSyncListener) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, forceSyncListener);
    }

    public Query follow() {
        return this.follow(true);
    }

    public Query follow(boolean follow) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query preloadWindow() {
        return this.preloadWindow(true);
    }

    public Query preloadWindow(boolean preloadWindow) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, preloadWindow, this.reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query reduceHistory(String reduceHistory) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, reduceHistory, this.description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query description(String description) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, description, this.lookupValues, this.source, this.forceSyncListener);
    }

    public Query lookupValues(Map<String, List<String>> lookupValues) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, lookupValues, this.source, this.forceSyncListener);
    }

    @Deprecated
    public boolean getTrackSkipRealtime() {
        return true;
    }

    public Query source(Object source) {
        return new Query(this.provider, this.expression, this.prefilter, this.listener, this.span, this.enforceDependencies, this.follow, this.preloadWindow, this.reduceHistory, this.description, this.lookupValues, source, this.forceSyncListener);
    }

    public String getProvider() {
        return this.provider;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getPrefilter() {
        return this.prefilter;
    }

    public QueryListener getListener() {
        if (this.listener == null) {
            return new QueryListener.Empty(){};
        }
        return this.listener;
    }

    public String getSpan() {
        if (Strings.isNullOrEmpty((String)this.span)) {
            return "none";
        }
        return this.span;
    }

    public boolean getForceSyncListener() {
        return this.forceSyncListener;
    }

    public boolean getFollow() {
        return this.follow;
    }

    public boolean getPreloadWindow() {
        return this.preloadWindow;
    }

    public boolean getEnforceDependencies() {
        return this.enforceDependencies;
    }

    public String getReduceHistory() {
        return this.reduceHistory;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, List<String>> getLookupValues() {
        return this.lookupValues;
    }

    public String toString() {
        String str = this.provider + "{" + this.expression + "}";
        if (this.prefilter != null) {
            str = str + "/prefilter(" + this.prefilter + ")";
        }
        if (this.reduceHistory != null) {
            str = str + "/reduce(" + this.reduceHistory + ")";
        }
        if (this.description != null) {
            str = str + "/desc(" + this.description + ")";
        }
        if (this.span != null) {
            str = str + "/span(" + this.span + ")";
        }
        if (this.enforceDependencies) {
            str = str + "/enforce";
        }
        if (this.listener == null) {
            str = str + "/nolistener";
        }
        if (this.follow) {
            str = str + "/follow";
        }
        if (this.lookupValues != null && this.lookupValues.size() > 0) {
            str = str + "/lookup(" + this.lookupValues + ")";
        }
        if (this.preloadWindow) {
            str = str + "/preload";
        }
        if (this.forceSyncListener) {
            str = str + "/forceSyncListener";
        }
        if (this.source != null) {
            str = str + "/source(" + this.source + ")";
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query that = (Query)o;
        return Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.provider, (Object)that.provider) && Objects.equal((Object)this.expression, (Object)that.expression) && Objects.equal((Object)this.prefilter, (Object)that.prefilter) && Objects.equal((Object)this.reduceHistory, (Object)that.reduceHistory) && Objects.equal((Object)this.follow, (Object)that.follow) && Objects.equal((Object)this.span, (Object)that.span) && Objects.equal((Object)this.enforceDependencies, (Object)that.enforceDependencies) && Objects.equal(this.lookupValues, that.lookupValues) && Objects.equal((Object)this.source, (Object)that.source) && Objects.equal((Object)this.preloadWindow, (Object)that.preloadWindow) && Objects.equal((Object)this.forceSyncListener, (Object)that.forceSyncListener);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.provider, this.expression, this.prefilter, this.reduceHistory, this.follow, this.span, this.enforceDependencies, this.lookupValues, true, this.source, this.preloadWindow, this.forceSyncListener});
    }

    public Object getSource() {
        return this.source;
    }

    public String getEventType() {
        if (this.source instanceof Datasource) {
            return ((Datasource)this.source).getEventType();
        }
        return null;
    }
}

