/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.intelie.live.Query;
import net.intelie.live.QueryAtom;

public class QueryRequest {
    private String provider;
    private String expression;
    private boolean follow = false;
    private boolean enforce = false;
    private boolean preload = false;
    private String prefilter = null;
    private String reducer = null;
    private String span = null;
    private String description = null;
    private String url = null;
    private Map<?, ?> lookupValues = null;

    public QueryRequest() {
        this.provider = "pipes";
        this.expression = "";
    }

    public QueryRequest(String provider, String expression, String span, String description) {
        this.provider = provider;
        this.expression = expression;
        this.span = span;
        this.description = description;
    }

    @Deprecated
    public QueryRequest(String provider, String expression, boolean follow, boolean enforce, String reducer, String span, String description, String url, boolean preload, boolean trackSkipRealtime, Map<?, ?> lookupValues, String prefilter) {
        this(provider, expression, follow, enforce, reducer, span, description, url, preload, lookupValues, prefilter);
    }

    private QueryRequest(String provider, String expression, boolean follow, boolean enforce, String reducer, String span, String description, String url, boolean preload, Map<?, ?> lookupValues, String prefilter) {
        this.provider = provider;
        this.expression = expression;
        this.follow = follow;
        this.enforce = enforce;
        this.reducer = reducer;
        this.span = span;
        this.description = description;
        this.url = url;
        this.preload = preload;
        this.lookupValues = lookupValues;
        this.prefilter = prefilter;
    }

    public QueryRequest withProvider(String provider) {
        return new QueryRequest(provider, this.expression, this.follow, this.enforce, this.reducer, this.span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withExpression(String expression) {
        return new QueryRequest(this.provider, expression, this.follow, this.enforce, this.reducer, this.span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withFollow(boolean follow) {
        return new QueryRequest(this.provider, this.expression, follow, this.enforce, this.reducer, this.span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withEnforce(boolean enforce) {
        return new QueryRequest(this.provider, this.expression, this.follow, enforce, this.reducer, this.span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withReducer(String reducer) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, reducer, this.span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withSpan(String span) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, span, this.description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withDescription(String description) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, this.span, description, this.url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withUrl(String url) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, this.span, this.description, url, this.preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withPreload(boolean preload) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, this.span, this.description, this.url, preload, this.lookupValues, this.prefilter);
    }

    public QueryRequest withLookupValues(Map<?, ?> lookupValues) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, this.span, this.description, this.url, this.preload, lookupValues, this.prefilter);
    }

    public QueryRequest withPrefilter(String prefilter) {
        return new QueryRequest(this.provider, this.expression, this.follow, this.enforce, this.reducer, this.span, this.description, this.url, this.preload, this.lookupValues, prefilter);
    }

    public static Map<String, List<String>> makeValues(Map<?, ?> lookupValues) {
        HashMap<String, List<String>> answer = new HashMap<String, List<String>>();
        if (lookupValues == null) {
            return answer;
        }
        for (Map.Entry<?, ?> entry : lookupValues.entrySet()) {
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value == null) continue;
            List list = answer.computeIfAbsent(key, k -> new ArrayList());
            if (value instanceof List) {
                for (Object o : (List)value) {
                    list.add(String.valueOf(o));
                }
                continue;
            }
            list.add(String.valueOf(value));
        }
        return answer;
    }

    public QueryAtom makeAtom() {
        Query query = new Query(this.provider, this.expression).follow(this.follow).preloadWindow(this.preload).reduceHistory(this.reducer).prefilter(this.prefilter).span(this.span).description(this.description).lookupValues(QueryRequest.makeValues(this.lookupValues)).enforceDependencies(this.enforce);
        return new QueryAtom(query, this.url);
    }
}

