/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.intelie.live.Callback;
import net.intelie.live.LiveJson;
import net.intelie.live.SettingsNode;
import net.intelie.live.SettingsOptions;
import net.intelie.live.SettingsProvider;
import net.intelie.live.util.PathUtils;
import net.intelie.pipes.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsNodeImpl
implements SettingsNode {
    private final SettingsProvider provider;
    private final String path;
    private final String content;

    public SettingsNodeImpl(@NotNull SettingsProvider provider, @NotNull String path) {
        this(provider, path, null);
    }

    public SettingsNodeImpl(@NotNull SettingsProvider provider, @NotNull String path, @Nullable String content) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.startsWith("/"), (Object)"Path must start with /");
        this.provider = provider;
        this.path = PathUtils.addSlash(PathUtils.fixFirst(path));
        this.content = content;
    }

    @Override
    @NotNull
    public String name() {
        return PathUtils.last(this.path);
    }

    @Override
    @NotNull
    public String path() {
        return this.path;
    }

    @Override
    @NotNull
    public SettingsNode cd(@NotNull String subPath, Object ... objs) {
        return new SettingsNodeImpl(this.provider, PathUtils.join(this.path, String.format(null, subPath, objs)), null);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull Class<T> type) {
        String text;
        String string = text = this.content != null ? this.content : this.provider.get(this.path);
        if (text == null) {
            return null;
        }
        return LiveJson.fromJson(text, type);
    }

    @Override
    @Nullable
    public String raw() {
        return this.content != null ? this.content : this.provider.get(this.path);
    }

    @Override
    public void set(@Nullable Object obj) {
        this.inTransaction(() -> {
            List<String> parents = PathUtils.parents(this.path);
            Set<String> toInsert = this.provider.checkPaths(new LinkedHashSet<String>(parents));
            for (String parentPath : toInsert) {
                this.provider.set(parentPath, null);
            }
            this.provider.set(this.path, LiveJson.toJson(obj));
            return null;
        });
    }

    @Override
    public void delete() {
        this.provider.delete(this.path);
    }

    @Override
    @NotNull
    public List<SettingsNode> children() {
        return this.children(1);
    }

    @Override
    @NotNull
    public List<SettingsNode> children(int levels) {
        ArrayList<SettingsNode> nodes = new ArrayList<SettingsNode>();
        for (SettingsProvider.Holder holder : this.provider.getChildren(this.path, levels)) {
            nodes.add(new SettingsNodeImpl(this.provider, holder.path(), holder.content()));
        }
        return nodes;
    }

    @Override
    public <T, E extends Throwable> T inTransaction(@NotNull Callback<T, E> callback) throws E {
        return this.provider.transact(new SettingsOptions(), this.path, callback);
    }

    @Override
    public <T, E extends Throwable> T inTransaction(@NotNull SettingsOptions options, @NotNull Callback<T, E> callback) throws E {
        return this.provider.transact(options, this.path, callback);
    }
}

