/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import net.intelie.live.Live;
import net.intelie.live.SettingsNode;
import net.intelie.live.SettingsNodeImpl;
import net.intelie.live.SettingsProvider;
import net.intelie.live.SettingsRoot;
import org.jetbrains.annotations.NotNull;

public class SettingsRootImpl
implements SettingsRoot,
Live.Settings {
    private final SettingsProvider provider;
    private final String prefix;

    public SettingsRootImpl(@NotNull SettingsProvider provider, @NotNull String prefix) {
        this.provider = provider;
        this.prefix = prefix;
    }

    @Override
    @NotNull
    public SettingsRoot as(@NotNull String prefix) {
        return new SettingsRootImpl(this.provider, prefix);
    }

    @Override
    @NotNull
    public SettingsNode root() {
        return new SettingsNodeImpl(this.provider, "/");
    }

    @Override
    @NotNull
    public SettingsNode home() {
        return this.root().cd("/%s", this.prefix);
    }

    @Override
    @NotNull
    public SettingsNode shared() {
        return this.root().cd("/shared", new Object[0]);
    }

    @Override
    @NotNull
    public SettingsNode sharedUser(int userId) {
        return this.shared().cd("/user/%d/%s", userId, this.prefix);
    }

    @Override
    @NotNull
    public SettingsNode privateUser(int userId) {
        return this.home().cd("/user/%d", userId);
    }
}

