/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import net.intelie.live.ControlEvent;
import net.intelie.live.Event;
import net.intelie.live.QueryEvent;
import net.intelie.live.QueryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SilentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SilentListener.class);

    public static void send(QueryListener listener, ControlEvent event) {
        try {
            listener.onControl(event);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                LOGGER.warn("Exception while sending control event: {}", (Object)event);
                LOGGER.info("Exception while sending control event. Stacktrace", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void send(QueryListener listener, QueryEvent event, boolean history) {
        try {
            listener.onEvent(event, history);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                LOGGER.warn("Exception while sending event: {}", (Object)event);
                LOGGER.info("Exception while sending event. Stacktrace", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Event sendFlow(QueryListener listener, Event event, boolean history) {
        try {
            return listener.onFlow(event, history);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                LOGGER.warn("Exception while sending flow: {}", (Object)event);
                LOGGER.info("Exception while sending flow. Stacktrace", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return event;
        }
    }
}

