/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.intelie.live.Event;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterOptimizer;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.UnionSpan;
import org.jetbrains.annotations.NotNull;

public class StorageQuery {
    private static final EnumSet<Flag> FOR_CACHE = EnumSet.of(Flag.NOCACHE, Flag.REVERSED);
    private final String type;
    private final Filter where;
    private final Set<String> select;
    private final int limit;
    private final String timestamp;
    private final EnumSet<Flag> flags;
    private final Filter intervalFilter;
    private final TimeSpan span;
    private final Map<String, Object> extra;

    public StorageQuery(String type) {
        this(type, null, null, 0, null, null, null, null, null);
    }

    @Deprecated
    public StorageQuery(String type, Filter where) {
        this(type, where, null, 0, null, null, null, null, null);
    }

    @Deprecated
    public StorageQuery(String type, Filter where, Set<String> select) {
        this(type, where, select, 0, null, null, null, null, null);
    }

    @Deprecated
    public StorageQuery(String type, Filter where, Set<String> select, int limit) {
        this(type, where, select, limit, null, null, null, null, null);
    }

    @Deprecated
    public StorageQuery(String type, Filter where, Set<String> select, int limit, String timestamp) {
        this(type, where, select, limit, timestamp, null, null, null, null);
    }

    private StorageQuery(String type, Filter where, Set<String> select, int limit, String timestamp, EnumSet<Flag> flags, Filter intervalFilter, TimeSpan span, Map<String, Object> extra) {
        if (where == null) {
            where = new AndFilter(new Filter[0]);
        }
        if (Strings.isNullOrEmpty((String)timestamp)) {
            timestamp = "timestamp";
        }
        if (flags == null) {
            flags = EnumSet.noneOf(Flag.class);
        }
        if (intervalFilter == null) {
            intervalFilter = new AndFilter(new Filter[0]);
        }
        this.type = Event.normalize(type);
        this.where = where;
        this.select = select;
        this.limit = limit;
        this.timestamp = timestamp;
        this.flags = flags;
        this.intervalFilter = intervalFilter;
        this.span = span;
        this.extra = extra != null ? extra : Collections.emptyMap();
    }

    private static int computeLimit(int limit1, int limit2) {
        if (limit1 == 0 || limit2 == 0 || limit1 < 0 != limit2 < 0) {
            return 0;
        }
        if (Math.abs(limit1) > Math.abs(limit2)) {
            return limit1;
        }
        return limit2;
    }

    private static Filter computeOr(Filter filter1, Filter filter2) throws PipeException {
        return FilterOptimizer.optimize((Filter)new OrFilter(new Filter[]{filter1, filter2}));
    }

    private static Sets.SetView<String> computeUnion(Set<String> set1, Set<String> set2) {
        if (set1 == null || set2 == null) {
            return null;
        }
        return Sets.union(set1, set2);
    }

    private static EnumSet<Flag> computeFlags(Set<Flag> set1, Set<Flag> set2) {
        EnumSet<Flag> union = EnumSet.noneOf(Flag.class);
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public StorageQuery withType(String type) {
        return new StorageQuery(type, this.where, this.select, this.limit, this.timestamp, this.flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withWhere(Filter where) {
        return new StorageQuery(this.type, where, this.select, this.limit, this.timestamp, this.flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withNoSelect() {
        return this.withSelect((Set<String>)null);
    }

    public StorageQuery withSelect(String ... select) {
        return this.withSelect(new LinkedHashSet<String>(Arrays.asList(select)));
    }

    public StorageQuery withSelect(Set<String> select) {
        return new StorageQuery(this.type, this.where, select, this.limit, this.timestamp, this.flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withLimit(int limit) {
        return new StorageQuery(this.type, this.where, this.select, limit, this.timestamp, this.flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withTimestamp(String timestamp) {
        return new StorageQuery(this.type, this.where, this.select, this.limit, timestamp, this.flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withFlags(Flag ... flags) {
        return this.withFlags(Arrays.asList(flags));
    }

    public StorageQuery withFlags(Collection<Flag> flags) {
        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
        set.addAll(flags);
        return this.withFlags(set);
    }

    public StorageQuery withFlags(EnumSet<Flag> flags) {
        return new StorageQuery(this.type, this.where, this.select, this.limit, this.timestamp, flags, this.intervalFilter, this.span, this.extra);
    }

    public StorageQuery withIntervalFilter(Filter intervalFilter) {
        return new StorageQuery(this.type, this.where, this.select, this.limit, this.timestamp, this.flags, intervalFilter, this.span, this.extra);
    }

    public StorageQuery withSpan(TimeSpan span) {
        return new StorageQuery(this.type, this.where, this.select, this.limit, this.timestamp, this.flags, this.intervalFilter, span, this.extra);
    }

    public StorageQuery withExtra(Map<String, Object> extra) {
        return new StorageQuery(this.type, this.where, this.select, this.limit, this.timestamp, this.flags, this.intervalFilter, this.span, extra);
    }

    public String type() {
        return this.type;
    }

    public Filter where() {
        return this.where;
    }

    public Set<String> select() {
        return this.select;
    }

    public int limit() {
        return this.limit;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public Set<Flag> flags() {
        return this.flags;
    }

    public TimeSpan span() {
        return this.span;
    }

    public boolean hasFlag(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public StorageQuery merge(StorageQuery other) throws PipeException {
        return new StorageQuery(this.type, StorageQuery.computeOr(this.where, other.where), (Set<String>)StorageQuery.computeUnion(this.select, other.select), StorageQuery.computeLimit(this.limit, other.limit), this.timestamp, StorageQuery.computeFlags(this.flags, other.flags), FilterOptimizer.optimize((Filter)new OrFilter(new Filter[]{this.intervalFilter, other.intervalFilter})), this.mergeSpan(other), (Map<String, Object>)this.mergeExtra(this.extra, other.extra));
    }

    private TimeSpan mergeSpan(StorageQuery other) {
        if (this.span == null) {
            return other.span;
        }
        if (other.span == null) {
            return this.span;
        }
        return new UnionSpan(Arrays.asList(this.span, other.span));
    }

    @NotNull
    public HashMap<String, Object> mergeExtra(Map<String, Object> a, Map<String, Object> b) {
        HashMap<String, Object> map = new HashMap<String, Object>(a);
        map.putAll(b);
        return map;
    }

    public StorageQuery forCache() {
        EnumSet<Flag> flags = EnumSet.copyOf(this.flags);
        flags.retainAll(FOR_CACHE);
        return this.withFlags(flags).forStorage();
    }

    public StorageQuery forStorage() {
        return this.withIntervalFilter(null).withExtra(null);
    }

    public boolean isSelectSupersetOf(StorageQuery that) {
        return this.lenientEquals(that, true, true) && StorageQuery.selectContains(this.select, that.select);
    }

    public boolean isSameQuery(StorageQuery that) {
        return this.lenientEquals(that, false, true);
    }

    private static boolean selectContains(Set<String> thisSelect, Set<String> thatSelect) {
        return thisSelect == null || thatSelect != null && thisSelect.containsAll(thatSelect);
    }

    private boolean lenientEquals(Object o, boolean ignoreSelect, boolean ignoreNonIdentify) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageQuery that = (StorageQuery)o;
        return !(!Objects.equals(this.type, that.type) || !Objects.equals(this.where, that.where) || !ignoreSelect && !Objects.equals(this.select, that.select) || !Objects.equals(this.limit, that.limit) || !Objects.equals(this.timestamp, that.timestamp) || !Objects.equals(this.flags, that.flags) || !ignoreNonIdentify && !Objects.equals(this.span, that.span) || !ignoreNonIdentify && !Objects.equals(this.extra, that.extra) || !Objects.equals(this.intervalFilter, that.intervalFilter));
    }

    public boolean equals(Object o) {
        return this.lenientEquals(o, false, false);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.where, this.select, this.limit, this.timestamp, this.flags, this.span, this.extra, this.intervalFilter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.type);
        if (!AndFilter.isAll((Filter)this.where)) {
            sb.append(" .where:'").append(this.where).append("'");
        }
        if (this.select != null) {
            sb.append(" .select:'").append(Joiner.on((char)',').join(this.select)).append("'");
        }
        if (this.limit != 0) {
            sb.append(" .limit:").append(this.limit);
        }
        if (!"timestamp".equals(this.timestamp)) {
            sb.append(" .timestamp:'").append(this.timestamp).append("'");
        }
        if (!this.flags.isEmpty()) {
            sb.append(" .flags:'").append(Joiner.on((char)',').join(this.flags)).append("'");
        }
        if (this.span != null) {
            sb.append(" .span:'").append(this.span).append("'");
        }
        if (!this.extra.isEmpty()) {
            sb.append(" .extra:'").append(this.extra).append("'");
        }
        if (!AndFilter.isAll((Filter)this.intervalFilter)) {
            sb.append(' ').append(this.intervalFilter);
        }
        return sb.toString();
    }

    public Filter getIntervalFilter() {
        return this.intervalFilter;
    }

    public Map<String, Object> extra() {
        return Collections.unmodifiableMap(this.extra);
    }

    public static enum Flag {
        NOCACHE,
        NOAUTOSELECT,
        NOMETRICS,
        NOCOUNT,
        NOASYNC,
        FORCEASYNC,
        NOINDEX,
        FORCECOUNT,
        REVERSED;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

