/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.intelie.live.TypeStatistics;

public class StorageStatistics {
    private final long count;
    private final long bytesUsed;
    private final List<TypeStatistics> types;
    private final long dataSize;
    private final Long fsUsed;
    private final Long fsTotal;

    public StorageStatistics(TypeStatistics ... types) {
        this((Long)null, (Long)null, types);
    }

    public StorageStatistics(Long fsUsed, Long fsTotal, TypeStatistics ... types) {
        this(fsUsed, fsTotal, Arrays.asList(types));
    }

    public StorageStatistics(Long fsUsed, Long fsTotal, Iterable<TypeStatistics> types) {
        this.types = Ordering.natural().reverse().immutableSortedCopy(types);
        long count = 0L;
        long bytesUsed = 0L;
        long dataSize = 0L;
        for (TypeStatistics type : types) {
            count += type.count();
            bytesUsed += type.bytesUsed();
            dataSize += type.dataSize();
        }
        this.count = count;
        this.bytesUsed = bytesUsed;
        this.dataSize = dataSize;
        this.fsUsed = fsUsed;
        this.fsTotal = fsTotal;
    }

    public static StorageStatistics merge(Iterable<StorageStatistics> stats) {
        LinkedHashMap<String, TypeStatistics> result = new LinkedHashMap<String, TypeStatistics>();
        Long minFsUsed = null;
        Long minFsTotal = null;
        Long minFsRemaining = null;
        for (StorageStatistics stat : stats) {
            if (stat.fsUsed != null && stat.fsTotal != null && (minFsRemaining == null || stat.fsTotal - stat.fsUsed < minFsRemaining)) {
                minFsRemaining = stat.fsTotal - stat.fsUsed;
                minFsUsed = stat.fsUsed;
                minFsTotal = stat.fsTotal;
            }
            for (TypeStatistics type : stat.types()) {
                result.put(type.type(), TypeStatistics.merge((TypeStatistics)result.get(type.type()), type));
            }
        }
        return new StorageStatistics(minFsUsed, minFsTotal, result.values());
    }

    public List<TypeStatistics> types() {
        return this.types;
    }

    public long count() {
        return this.count;
    }

    public long bytesUsed() {
        return this.bytesUsed;
    }

    public long dataSize() {
        return this.dataSize;
    }

    public Long fsUsed() {
        return this.fsUsed;
    }

    public Long fsTotal() {
        return this.fsTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageStatistics)) {
            return false;
        }
        StorageStatistics that = (StorageStatistics)o;
        return Objects.equals(this.types, that.types) && Objects.equals(this.fsUsed, that.fsUsed) && Objects.equals(this.fsTotal, that.fsTotal);
    }

    public int hashCode() {
        return Objects.hash(this.types, this.fsUsed, this.fsTotal);
    }

    public String toString() {
        return (this.fsUsed != null ? "FS Used: " + this.fsUsed + "\n" : "") + (this.fsTotal != null ? "FS Total: " + this.fsTotal + "\n" : "") + Joiner.on((String)"\n").join(this.types);
    }
}

