/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.primitives.Longs;
import java.util.Objects;
import net.intelie.live.Event;

public class TypeStatistics
implements Comparable<TypeStatistics> {
    private final String type;
    private final long count;
    private final long bytesUsed;
    private final long dataSize;

    public TypeStatistics(String type, long count, long bytesUsed, long dataSize) {
        this.dataSize = dataSize;
        this.type = Event.normalize(type);
        this.count = count;
        this.bytesUsed = bytesUsed;
    }

    public static TypeStatistics merge(TypeStatistics a, TypeStatistics b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new TypeStatistics(a.type, a.count + b.count, a.bytesUsed + b.bytesUsed, a.dataSize + b.dataSize);
    }

    public String type() {
        return this.type;
    }

    public long count() {
        return this.count;
    }

    public long bytesUsed() {
        return this.bytesUsed;
    }

    public long dataSize() {
        return this.dataSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeStatistics)) {
            return false;
        }
        TypeStatistics that = (TypeStatistics)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.count, that.count) && Objects.equals(this.bytesUsed, that.bytesUsed) && Objects.equals(this.dataSize, that.dataSize);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.count, this.bytesUsed);
    }

    public String toString() {
        return this.type + ": " + this.count + " events, " + this.bytesUsed + " bytes, " + this.dataSize + " bytes original";
    }

    @Override
    public int compareTo(TypeStatistics that) {
        int compare = Longs.compare((long)this.bytesUsed, (long)that.bytesUsed);
        if (compare != 0) {
            return compare;
        }
        compare = Longs.compare((long)this.dataSize, (long)that.dataSize);
        if (compare != 0) {
            return compare;
        }
        return Longs.compare((long)this.count, (long)that.count);
    }
}

