/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class UserAuthInfo {
    private final String username;
    private final String email;
    private final String name;
    private final Set<Integer> defaultGroups;

    public UserAuthInfo(String username, String email, String name, Integer defaultGroup) {
        this(username, email, name, defaultGroup != null ? Collections.singleton(defaultGroup) : Collections.emptySet());
    }

    public UserAuthInfo(String username, String email, String name, Set<Integer> defaultGroups) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"User must have a name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (Object)"User must have a username");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"User must have a valid email address");
        Preconditions.checkArgument((defaultGroups != null ? 1 : 0) != 0, (Object)"User default groups must not be null");
        this.username = username;
        this.email = email;
        this.name = name;
        this.defaultGroups = defaultGroups;
    }

    public String username() {
        return this.username;
    }

    public String email() {
        return this.email;
    }

    public String name() {
        return this.name;
    }

    public Set<Integer> defaultGroups() {
        return this.defaultGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuthInfo that = (UserAuthInfo)o;
        return Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.defaultGroups, that.defaultGroups);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.username, this.email, this.name, this.defaultGroups});
    }

    public String toString() {
        return String.format((Locale)null, "%s <%s> (%s)", this.username, this.email, this.name);
    }
}

