/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.DashboardUserViewCount;
import net.intelie.live.model.DashboardUserViewTimestamp;
import net.intelie.live.model.DashboardViewCount;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasModelVersion;
import net.intelie.live.model.HasPerspective;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.HasVisibilityStatus;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.User;
import net.intelie.live.model.VisibilityStatus;
import net.intelie.live.model.Widget;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.validator.constraints.Length;

@Entity
@Table
public class Dashboard
implements Serializable,
HasPerspective,
HasUpdateInfo,
HasModelVersion,
HasVisibilityStatus {
    private static final long serialVersionUID = 1L;
    @OneToMany(targetEntity=Widget.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="dashboard_widget", inverseJoinColumns={@JoinColumn(name="widget_id")}, joinColumns={@JoinColumn(name="dashboard_id")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=10)
    private final Set<Widget> widgets = new LinkedHashSet<Widget>();
    @OneToMany(mappedBy="dashboard")
    @Filter(name="currentUser", condition="user_id = :current_user_id")
    private final Set<DashboardUserViewCount> userViewCount = new HashSet<DashboardUserViewCount>();
    @OneToMany(mappedBy="dashboard")
    @Filter(name="currentUser", condition="user_id = :current_user_id")
    private final Set<DashboardUserViewTimestamp> userViewTimestamp = new HashSet<DashboardUserViewTimestamp>();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    protected VisibilityStatus visibility;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="dashboard_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Column(unique=true)
    private String title;
    @ManyToOne
    @JoinColumn(name="perspective_id")
    @NotNull
    private Perspective perspective;
    @Column(name="span")
    private String span;
    @Column(name="widgets_request_config")
    private String widgetsRequests;
    @Column(name="json_config")
    private String jsonConfig;
    @Deprecated
    @Column(name="layout_json_config")
    private String layoutConfig;
    @Column
    private String token;
    @Column(name="model_version")
    private String modelVersion;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;
    @OneToOne(mappedBy="dashboard")
    private DashboardViewCount viewCount;

    public Dashboard() {
    }

    public Dashboard(int id) {
        this.setId(id);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public Set<Widget> getWidgets() {
        return this.widgets;
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public void removeWidget(Widget widget) {
        this.widgets.remove(widget);
    }

    public String getSpan() {
        return this.span;
    }

    public void setSpan(String span) {
        this.span = span;
    }

    public String getWidgetsRequests() {
        return this.widgetsRequests;
    }

    public void setWidgetsRequests(String widgetsRequests) {
        this.widgetsRequests = widgetsRequests;
    }

    public String getJsonConfig() {
        return this.jsonConfig;
    }

    public void setJsonConfig(String jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    @Deprecated
    public String getLayoutConfig() {
        return this.layoutConfig;
    }

    @Deprecated
    public void setLayoutConfig(String layoutConfig) {
        this.layoutConfig = layoutConfig;
    }

    public void replaceWidgets(Set<Widget> widgets) {
        ArrayList toRemove = Lists.newArrayList((Iterable)Sets.difference(this.widgets, widgets));
        ArrayList toAdd = Lists.newArrayList((Iterable)Sets.difference(widgets, this.widgets));
        this.widgets.removeAll(toRemove);
        this.widgets.addAll(toAdd);
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public VisibilityStatus getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityStatus visibility) {
        this.visibility = visibility;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void createToken() {
        if (this.token == null) {
            this.token = UUID.randomUUID().toString().replaceAll("-", "");
        }
    }

    @Override
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public DashboardViewCount getViewCount() {
        return this.viewCount;
    }

    public Set<DashboardUserViewCount> getUserViewCount() {
        return this.userViewCount;
    }

    public Set<DashboardUserViewTimestamp> getUserViewTimestamp() {
        return this.userViewTimestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard that = (Dashboard)o;
        return Entities.idEquals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }
}

