/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import net.intelie.live.ExtensionDef;
import net.intelie.live.ExtensionQualifier;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.User;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"type", "qualifier"})})
public class Extension
implements ExtensionDef,
Serializable,
HasUpdateInfo {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="extension_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Column
    private String type;
    @NotNull
    @Length(max=255)
    @Column
    private String qualifier;
    @Column
    private boolean active;
    @Column
    private String config;
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;

    public Extension() {
    }

    public Extension(int id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.qualifier = qualifier;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @Override
    public ExtensionQualifier getQualifierObject() {
        return new ExtensionQualifier(this.type, this.qualifier);
    }

    @Override
    public String getFullQualifier() {
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            return this.type;
        }
        return this.type + "/" + this.qualifier;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension that = (Extension)o;
        return Entities.idEquals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Extension{id=" + this.id + ", type='" + this.type + '\'' + ", qualifier='" + this.qualifier + '\'' + '}';
    }
}

