/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import org.hibernate.validator.constraints.Length;

@Entity
public class Role
implements HasUpdateInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="role_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Column(name="role", unique=true)
    @Unique
    private String name;
    @ElementCollection
    @JoinTable(name="role_permission", joinColumns={@JoinColumn(name="role_id")})
    @Column(name="permission")
    private final Set<String> permissions = new LinkedHashSet<String>();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;

    public Role() {
    }

    public Role(int id) {
        this.id = id;
    }

    public void addPermissions(String ... permissions) {
        Collections.addAll(this.permissions, permissions);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void replacePermissions(Set<String> permissions) {
        Entities.replaceSet(this.permissions, permissions);
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role that = (Role)o;
        return this.id != null && Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }
}

