/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import net.intelie.live.UserDef;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.Role;
import net.intelie.live.model.Unique;
import net.intelie.live.model.UserGroup;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="user")
@FilterDef(name="currentUser", parameters={@ParamDef(name="current_user_id", type="integer")})
public class User
implements Serializable,
HasUpdateInfo,
UserDetails,
UserDef {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="user_id")
    private Integer id;
    @NotNull
    @NotBlank
    @Length(max=255)
    @Column(unique=true)
    @Unique
    private String username;
    @Email(message="Email inv\u00e1lido")
    @Length(max=255)
    @Unique
    private String email;
    @Length(max=255)
    private String name;
    @Column
    private String password = "live_default_password";
    @Column(name="password_reset_token")
    private String passwordResetToken;
    @Column
    private boolean enabled = true;
    @Column
    private boolean superuser = false;
    @Column(name="session_expires")
    private boolean sessionExpires = true;
    @Column(name="csrf_protection")
    private boolean csrfProtection = true;
    @Length(max=255)
    @Column(name="auth_provider_id")
    private String authenticationProvider;
    @ManyToMany
    @JoinTable(name="usergroup_user", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="usergroup_id")})
    private Set<UserGroup> groups = new HashSet<UserGroup>();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;
    @Transient
    private boolean sendGreetings;
    @Transient
    private String currentPassword;
    @Transient
    private String newPassword;
    @Transient
    private String newPasswordConfirmation;

    public User() {
    }

    public User(int id) {
        this.id = id;
    }

    public User(String username) {
        this.username = username;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public Set<String> getPermissions() {
        return this.getPermissions(null);
    }

    @Override
    public Set<String> getPermissions(Integer perspectiveId) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (this.superuser) {
            permissions.add("ADMIN");
            permissions.add("SUPER_USER");
        }
        for (Role role : this.getRoles(perspectiveId)) {
            permissions.addAll(role.getPermissions());
        }
        return permissions;
    }

    public Set<Role> getRoles(Integer perspectiveId) {
        HashSet<Role> roles = new HashSet<Role>();
        for (UserGroup group : this.groups) {
            if (perspectiveId != null && !group.getAllPerspectivesAllowed().booleanValue() && !group.getPerspectives().contains(new Perspective(perspectiveId))) continue;
            roles.addAll(group.getRoles());
        }
        return roles;
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Integer> getGroupIds() {
        return this.groups.stream().map(UserGroup::getId).collect(Collectors.toSet());
    }

    public void replaceGroups(Set<UserGroup> groups) {
        Entities.replaceSet(this.groups, groups);
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return this.getPermissions().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    public void setUsername(String name) {
        this.username = name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public boolean isSuperuser() {
        return this.superuser;
    }

    public void setSuperuser(boolean superuser) {
        this.superuser = superuser;
    }

    public boolean isSessionExpires() {
        return this.sessionExpires;
    }

    public void setSessionExpires(boolean sessionExpires) {
        this.sessionExpires = sessionExpires;
    }

    public boolean hasCsrfProtection() {
        return this.csrfProtection;
    }

    public void setCsrfProtection(boolean csrfProtection) {
        this.csrfProtection = csrfProtection;
    }

    public String getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(String authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.name != null && !this.name.isEmpty() ? this.name : (this.email != null && !this.email.isEmpty() ? this.email : this.username);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getSendGreetings() {
        return this.sendGreetings;
    }

    public void setSendGreetings(Boolean sendGreetings) {
        this.sendGreetings = sendGreetings;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirmation() {
        return this.newPasswordConfirmation;
    }

    public void setNewPasswordConfirmation(String newPasswordConfirmation) {
        this.newPasswordConfirmation = newPasswordConfirmation;
    }

    public String getPasswordResetToken() {
        return this.passwordResetToken;
    }

    public void setPasswordResetToken(String passwordResetToken) {
        this.passwordResetToken = passwordResetToken;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    @Override
    public boolean hasChangedPassword() {
        return !"live_default_password".equals(this.password);
    }

    @Override
    public boolean isNew() {
        return this.getId() == null;
    }

    @Override
    public boolean hasConfirmedPassword() {
        return !Strings.isNullOrEmpty((String)this.newPassword) && !Strings.isNullOrEmpty((String)this.newPasswordConfirmation) && this.newPassword.equals(this.newPasswordConfirmation);
    }

    public void clearSensitiveData() {
        this.setCurrentPassword(null);
        this.setNewPassword(null);
        this.setNewPasswordConfirmation(null);
        this.setPasswordResetToken(null);
    }

    public void resetPassword() {
        this.resetPassword(true);
    }

    public void resetPassword(boolean usesTemporaryToken) {
        String newPassword = this.generateRandomPassword();
        if (usesTemporaryToken) {
            this.setPasswordResetToken(newPassword);
        } else {
            this.setPassword(newPassword);
        }
    }

    private String generateRandomPassword() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User that = (User)o;
        return this.id != null && Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return "User{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }
}

