/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.Role;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="usergroup")
public class UserGroup
implements Serializable,
HasUpdateInfo {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="usergroup_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Column(unique=true)
    @NotBlank
    @Unique
    private String name;
    @ManyToMany
    @JoinTable(name="usergroup_user", joinColumns={@JoinColumn(name="usergroup_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    @ForeignKey(name="usergroup_user_usergroup_id", inverseName="usergroup_user_user_id")
    private Set<User> users = new HashSet<User>();
    @ManyToMany(targetEntity=Role.class)
    @JoinTable(name="usergroup_role", joinColumns={@JoinColumn(name="usergroup_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private final Set<Role> roles = new HashSet<Role>();
    @ManyToMany
    @JoinTable(name="usergroup_perspective", joinColumns={@JoinColumn(name="usergroup_id")}, inverseJoinColumns={@JoinColumn(name="perspective_id")})
    private final Set<Perspective> perspectives = new HashSet<Perspective>();
    @Column(name="all_perspectives_allowed")
    private Boolean allPerspectivesAllowed = false;
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;

    public UserGroup() {
    }

    public UserGroup(int id) {
        this.id = id;
    }

    public UserGroup(int id, String name) {
        this(id);
        this.name = name;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public void addPerspective(Perspective perspective) {
        this.perspectives.add(perspective);
    }

    public void removePerspective(Perspective perspective) {
        this.perspectives.remove(perspective);
    }

    public Set<User> getUsers() {
        return this.users;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Set<Perspective> getPerspectives() {
        return this.perspectives;
    }

    public Boolean getAllPerspectivesAllowed() {
        return this.allPerspectivesAllowed;
    }

    public void setAllPerspectivesAllowed(Boolean allPerspectivesAllowed) {
        this.allPerspectivesAllowed = allPerspectivesAllowed;
    }

    public void replaceUsers(Set<User> users) {
        Entities.replaceSet(this.users, users);
    }

    public void replacePerspectives(Set<Perspective> perspectives) {
        Entities.replaceSet(this.perspectives, perspectives);
    }

    public void replaceRoles(Set<Role> roles) {
        Entities.replaceSet(this.roles, roles);
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserGroup)) {
            return false;
        }
        UserGroup that = (UserGroup)o;
        return this.id != null && that.id != null && Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }
}

