/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.Dashboard;
import net.intelie.live.model.HasModelVersion;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.User;
import org.hibernate.validator.constraints.Length;

@Table(name="widget")
@Entity
public class Widget
implements HasUpdateInfo,
HasModelVersion,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="widget_id")
    protected Integer id;
    @NotNull
    @Length(max=255)
    protected String type;
    @Column(name="json_config")
    protected String jsonConfig;
    @NotNull
    @Length(max=255)
    protected String title;
    @Length(max=255)
    protected String description;
    @Column
    private String modelVersion;
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created", nullable=false)
    private Long dateCreated;
    @Column(name="date_modified", nullable=false)
    private Long dateModified;
    @ManyToOne
    @JoinTable(name="dashboard_widget", inverseJoinColumns={@JoinColumn(name="dashboard_id")}, joinColumns={@JoinColumn(name="widget_id")})
    protected Dashboard dashboard;

    public Widget() {
    }

    public Widget(Integer id) {
        this.id = id;
    }

    public Widget(String type) {
        this.type = type;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getJsonConfig() {
        return this.jsonConfig;
    }

    public void setJsonConfig(String jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    @Override
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public Widget duplicateFor(Dashboard dashboard) {
        Widget widget = new Widget();
        widget.setDashboard(dashboard);
        widget.setDescription(this.getDescription());
        widget.setJsonConfig(this.getJsonConfig());
        widget.setModelVersion(this.getModelVersion());
        widget.setTitle(this.getTitle());
        widget.setType(this.getType());
        return widget;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Widget && this.id != null && this.id.equals(((Widget)o).getId());
    }
}

