/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

public class ClassLoaderContext
implements AutoCloseable {
    private final Thread thread;
    private final ClassLoader savedContextClassLoader;

    public ClassLoaderContext(Class<?> cls) {
        this(cls.getClassLoader());
    }

    public ClassLoaderContext(ClassLoader classLoader) {
        this(Thread.currentThread(), classLoader);
    }

    public ClassLoaderContext(Thread thread, ClassLoader classLoader) {
        this.thread = thread;
        this.savedContextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
    }

    @Override
    public void close() {
        this.thread.setContextClassLoader(this.savedContextClassLoader);
    }
}

