/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.io.Serializable;
import java.util.Iterator;
import javax.transaction.Synchronization;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.intelie.live.Callback;
import net.intelie.live.EntityContext;
import net.intelie.live.EntityList;
import net.intelie.live.InvalidEntityException;
import net.intelie.live.ModelVersion;
import net.intelie.live.SecurityContextFactory;
import net.intelie.live.Specification;
import net.intelie.live.UserContext;
import net.intelie.live.model.HasCreationInfo;
import net.intelie.live.model.HasModelVersion;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.User;
import net.intelie.live.queries.AllUsers;
import net.intelie.live.util.EntityValidator;
import net.intelie.pipes.time.Clock;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.UserDetails;

public class EntityContextBase
implements EntityContext,
UserContext {
    public static final String CURRENT_USER_FILTER = "currentUser";
    public static final String CURRENT_USER_ID = "current_user_id";
    private final SessionFactory factory;
    private final Clock clock;
    private final EntityValidator entityValidator;
    private final SecurityContextFactory security;

    @Autowired
    public EntityContextBase(SessionFactory factory, Clock clock, SecurityContextFactory security) {
        this.factory = factory;
        this.clock = clock;
        this.security = security;
        this.entityValidator = new EntityValidator(factory);
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public Clock getClock() {
        return this.clock;
    }

    public EntityValidator getEntityValidator() {
        return this.entityValidator;
    }

    public SecurityContextFactory getSecurity() {
        return this.security;
    }

    @Override
    public <T> T get(Class<T> type, Serializable pk) {
        return (T)this.session().get(type, pk);
    }

    @Override
    public void evict(Object obj) {
        this.session().evict(obj);
    }

    @Override
    public Serializable save(Object entity) {
        this.setUpdateInfo(entity);
        this.setModelVersion(entity);
        this.entityValidator.validate(entity);
        try {
            return this.session().save(entity);
        }
        catch (ConstraintViolationException e) {
            Iterator iterator = e.getConstraintViolations().iterator();
            String message = "";
            if (iterator.hasNext()) {
                message = ((ConstraintViolation)iterator.next()).getMessage();
            }
            throw new InvalidEntityException(message);
        }
    }

    private void setUpdateInfo(Object entity) {
        if (entity instanceof HasCreationInfo) {
            HasCreationInfo createEntity = (HasCreationInfo)entity;
            long now = this.clock.now();
            User user = this.currentUser();
            if (createEntity.getId() == null) {
                createEntity.setDateCreated(now);
                createEntity.setAuthor(user);
            }
            if (entity instanceof HasUpdateInfo) {
                HasUpdateInfo updateEntity = (HasUpdateInfo)entity;
                updateEntity.setDateModified(now);
                updateEntity.setLastModificationAuthor(user);
            }
        }
    }

    private void setModelVersion(Object entity) {
        HasModelVersion updateEntity;
        if (entity instanceof HasModelVersion && (updateEntity = (HasModelVersion)entity).getModelVersion() == null) {
            updateEntity.setModelVersion(ModelVersion.CURRENT_MODEL_VERSION);
        }
    }

    @Override
    public void delete(Object entity) {
        this.session().delete(entity);
    }

    @Override
    public void flush() {
        this.session().flush();
    }

    @Override
    public void clear() {
        this.session().clear();
    }

    @Override
    public void onCommit(final Runnable runnable) {
        this.session().getTransaction().registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int i) {
                if (i == 3) {
                    runnable.run();
                }
            }
        });
    }

    @Override
    public <T, E extends Throwable> T inTransaction(Callback<T, E> callback) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> EntityList<T> find(Specification<T> spec) {
        return spec.all(this.session());
    }

    @Override
    public <T> T findOneOf(Specification<T> spec) {
        return spec.one(this.session());
    }

    @Override
    public <T> long count(Specification<T> spec) {
        return spec.count(this.session());
    }

    public Session session() {
        Session session = this.factory.getCurrentSession();
        User user = this.currentUser();
        if (user != null) {
            Filter filter = session.enableFilter(CURRENT_USER_FILTER);
            filter.setParameter(CURRENT_USER_ID, (Object)user.getId());
        }
        return session;
    }

    @Override
    public User currentUser() {
        UserDetails details = this.getUserDetails();
        if (details == null) {
            return null;
        }
        return (User)new AllUsers().byUsername(details.getUsername()).one(this.getFactory().getCurrentSession());
    }

    public UserDetails getUserDetails() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof UserDetails)) {
            return null;
        }
        return (UserDetails)principal;
    }

    @Override
    public String currentUsername() {
        UserDetails details = this.getUserDetails();
        if (details == null) {
            return null;
        }
        return details.getUsername();
    }

    private Authentication getAuthentication() {
        SecurityContext context = this.security.getContext();
        if (context == null) {
            return null;
        }
        return context.getAuthentication();
    }
}

