/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.lang.reflect.Field;
import java.util.List;
import javax.validation.constraints.Pattern;
import net.intelie.live.InvalidEntityException;
import net.intelie.live.model.Unique;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.hibernate.validator.constraints.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityValidator.class);
    private final SessionFactory factory;

    public EntityValidator(SessionFactory factory) {
        this.factory = factory;
    }

    public void validate(Object entity) throws InvalidEntityException {
        Class<?> entityClass = entity.getClass();
        this.testUniqueValues(entity, entityClass);
    }

    private void testUniqueValues(Object entity, Class<?> entityClass) throws InvalidEntityException {
        this.testForClass(entity, entityClass);
        Class<?> superclass = entityClass.getSuperclass();
        if (superclass != null) {
            this.testUniqueValues(entity, superclass);
        }
    }

    private void testForClass(Object entity, Class<?> entityClass) throws InvalidEntityException {
        for (Field field : entityClass.getDeclaredFields()) {
            field.setAccessible(true);
            this.checkUnique(entity, entityClass, field);
            this.checkPattern(entity, entityClass, field);
            this.checkLength(entity, entityClass, field);
        }
    }

    private void checkLength(Object entity, Class<?> entityClass, Field field) {
        Object fieldValue;
        String string;
        Length lengthAnnotation = field.getAnnotation(Length.class);
        if (lengthAnnotation != null && (string = EntityValidator.checkStringValue(field, fieldValue = EntityValidator.getFieldValue(entity, entityClass, field))) != null) {
            if (string.length() > lengthAnnotation.max()) {
                throw new InvalidEntityException("Valor muito longo para o campo " + field.getName());
            }
            if (string.length() < lengthAnnotation.min()) {
                throw new InvalidEntityException("Valor muito curto para o campo " + field.getName());
            }
        }
    }

    private void checkPattern(Object entity, Class<?> entityClass, Field field) {
        Pattern patternAnnotation = field.getAnnotation(Pattern.class);
        if (patternAnnotation != null) {
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(patternAnnotation.regexp());
            Object fieldValue = EntityValidator.getFieldValue(entity, entityClass, field);
            String string = EntityValidator.checkStringValue(field, fieldValue);
            if (string != null && !pattern.matcher(string).matches()) {
                throw new InvalidEntityException("O valor " + fieldValue + " n\u00e3o \u00e9 v\u00e1lido para o campo " + field.getName());
            }
        }
    }

    private void checkUnique(Object entity, Class<?> entityClass, Field field) {
        Object fieldValue;
        List list;
        String fieldName = field.getName();
        Unique uniqueAnnotation = field.getAnnotation(Unique.class);
        if (uniqueAnnotation != null && (list = this.listValuesWithEqualValue(entityClass, fieldName, fieldValue = EntityValidator.getFieldValue(entity, entityClass, field))).size() > 0) {
            Field idField = EntityValidator.getField(entityClass, "id");
            Object testedId = EntityValidator.getFieldValue(entity, entityClass, idField);
            for (Object o : list) {
                Object id = EntityValidator.getFieldValue(o, entityClass, idField);
                if (id.equals(testedId)) continue;
                throw new InvalidEntityException("O valor " + fieldValue + " j\u00e1 \u00e9 utilizado", fieldName);
            }
        }
    }

    private List listValuesWithEqualValue(Class<?> entityClass, String fieldName, Object fieldValue) {
        Criteria criteriaToCondition = this.factory.getCurrentSession().createCriteria(entityClass);
        criteriaToCondition = fieldValue == null ? criteriaToCondition.add(Restrictions.isNull((String)fieldName)) : criteriaToCondition.add(Restrictions.ilike((String)fieldName, (Object)fieldValue));
        return criteriaToCondition.setFlushMode(FlushMode.COMMIT).list();
    }

    public static String checkStringValue(Field field, Object fieldValue) {
        if (field.getType().isAssignableFrom(String.class) && (fieldValue == null || fieldValue instanceof String)) {
            return (String)fieldValue;
        }
        throw new InvalidEntityException("O campo " + field.getName() + " deve ser uma string");
    }

    public static Field getField(Class<?> entityClass, String name) {
        try {
            Field field = entityClass.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new InvalidEntityException("N\u00e3o foi poss\u00edvel obter o campo " + name + " na entidade " + entityClass.getName());
        }
    }

    public static Object getFieldValue(Object entity, Class<?> entityClass, Field field) {
        try {
            return field.get(entity);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not access field value for {} on {}", entityClass, entity);
            throw new InvalidEntityException("O campo " + field.getName() + " n\u00e3o pode ser acessado em " + entityClass.getName());
        }
    }
}

