/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.intelie.live.PersistentExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPersistentExecutor<T>
implements PersistentExecutor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyPersistentExecutor.class);
    private final ExecutorService executor;
    private final BlockingQueue<Runnable> queue;
    private final Consumer<T> consumer;
    private volatile boolean paused = false;

    public LegacyPersistentExecutor(ThreadPoolExecutor executor, Consumer<T> consumer) {
        this(executor, executor.getQueue(), consumer);
    }

    public LegacyPersistentExecutor(ExecutorService executor, BlockingQueue<Runnable> queue, Consumer<T> consumer) {
        this.executor = executor;
        this.queue = queue;
        this.consumer = consumer;
    }

    @Override
    public void submit(T obj) throws IOException {
        if (this.paused) {
            throw new IOException("Executor is paused");
        }
        this.executor.submit(() -> this.consumer.accept(obj));
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public long count() {
        return this.queue.size();
    }

    @Override
    public long bytes() {
        return this.queue.size();
    }

    @Override
    public long remainingBytes() {
        return this.queue.remainingCapacity();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.info("Executor shutdown wait interrupted", (Throwable)e);
        }
    }
}

