/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.sql.Connection;
import java.util.Set;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import net.intelie.live.util.MigrationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LiveMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiveMigrator.class);

    public static void execute(Connection connection, MigrationListener listener) throws Exception {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        LiveLiquibase liquibase = new LiveLiquibase("liquibase/master.yaml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        LOGGER.info("Migrating database to latest version...");
        liquibase.liveUpdate(listener);
    }

    public static class LiveLiquibase
    extends Liquibase {
        public LiveLiquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database db) throws LiquibaseException {
            super(changeLogFile, resourceAccessor, db);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void liveUpdate(final MigrationListener listener) throws Exception {
            Contexts contexts = new Contexts();
            LabelExpression labels = new LabelExpression();
            this.getChangeLogParameters().setContexts(contexts);
            this.getChangeLogParameters().setLabels(labels);
            try {
                DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
                this.checkLiquibaseTables(true, changeLog, contexts, labels);
                changeLog.validate(this.database, contexts, labels);
                ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(contexts, labels, changeLog);
                final UpdateVisitor visitor = this.createUpdateVisitor();
                changeLogIterator.run(new ChangeSetVisitor(){

                    public ChangeSetVisitor.Direction getDirection() {
                        return visitor.getDirection();
                    }

                    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> set) throws LiquibaseException {
                        if (listener != null) {
                            listener.onBefore(changeSet);
                        }
                        visitor.visit(changeSet, databaseChangeLog, database, set);
                        if (listener != null) {
                            listener.onAfter(changeSet);
                        }
                    }
                }, new RuntimeEnvironment(this.database, contexts, labels));
            }
            finally {
                this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                this.resetServices();
            }
        }
    }
}

