/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public abstract class RemoteHostUtils {
    private static final String[] HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static String makeHost(HttpServletRequest request) {
        String host = RemoteHostUtils.getRemoteHost(request);
        String user = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : "unknown";
        return String.format((Locale)null, "%s at %s", user, host);
    }

    public static String getRemoteHost(HttpServletRequest request) {
        for (String header : HEADERS) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() <= 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteHost();
    }
}

