/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import net.intelie.live.ControlEvent;
import net.intelie.live.DestroyInfo;
import net.intelie.live.Live;
import net.intelie.live.Query;
import net.intelie.live.QueryEvent;
import net.intelie.live.QueryListener;

public class SyncQuery {
    public static void runSyncQueries(Live.Engine engine, Query ... queries) throws Exception {
        SyncQuery.runSyncQueries(engine::runQueries, queries);
    }

    public static void runSyncQueries(RunQueries runQueries, Query ... queries) throws Exception {
        CountDownLatch[] latches = new CountDownLatch[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            QueryListener queryListener = (QueryListener)Preconditions.checkNotNull((Object)query.getListener());
            CountDownLatch latch = latches[i] = new CountDownLatch(1);
            Listener listener = queryListener instanceof Listener ? (Listener)queryListener : new DelegatingListener(queryListener);
            queries[i] = query.listenWith(new CountDownQueryListener(listener, latch));
        }
        try (AutoCloseable ac = runQueries.runQueries(queries);){
            for (CountDownLatch latch : latches) {
                latch.await();
            }
        }
    }

    private static final class CountDownQueryListener
    implements QueryListener {
        private final Listener listener;
        private final CountDownLatch latch;

        private CountDownQueryListener(Listener listener, CountDownLatch latch) {
            this.listener = listener;
            this.latch = latch;
        }

        @Override
        public void onEvent(QueryEvent event, boolean history) throws Exception {
            this.listener.onEvent(event, history, this.latch);
        }

        @Override
        public void onControl(ControlEvent event) throws Exception {
            if (event instanceof DestroyInfo) {
                this.latch.countDown();
            }
            this.listener.onControl(event);
        }
    }

    private static final class DelegatingListener
    implements Listener {
        private final QueryListener queryListener;

        private DelegatingListener(QueryListener queryListener) {
            this.queryListener = queryListener;
        }

        @Override
        public void onEvent(QueryEvent event, boolean history) throws Exception {
            this.queryListener.onEvent(event, history);
        }

        @Override
        public void onControl(ControlEvent event) throws Exception {
            this.queryListener.onControl(event);
        }
    }

    public static interface Listener
    extends QueryListener {
        default public void onEvent(QueryEvent event, boolean history, CountDownLatch latch) throws Exception {
            this.onEvent(event, history);
        }

        @Override
        default public void onEvent(QueryEvent event, boolean history) throws Exception {
        }

        @Override
        default public void onControl(ControlEvent event) throws Exception {
        }
    }

    @FunctionalInterface
    public static interface RunQueries {
        public AutoCloseable runQueries(Query ... var1) throws Exception;
    }
}

