/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import java.io.StringWriter;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.latex.renderer.LatexObjectVisitor;
import org.semanticweb.owlapi.latex.renderer.LatexWriter;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class LatexOWLObjectRenderer
implements OWLObjectRenderer {
    @Nonnull
    private final OWLDataFactory dataFactory;
    private ShortFormProvider shortFormProvider;

    public LatexOWLObjectRenderer(@Nonnull OWLDataFactory dataFactory) {
        this.dataFactory = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)dataFactory);
    }

    public String render(@Nonnull OWLObject object) {
        StringWriter writer = new StringWriter();
        LatexWriter latexWriter = new LatexWriter(writer);
        LatexObjectVisitor visitor = new LatexObjectVisitor(latexWriter, this.dataFactory);
        visitor.setShortFormProvider(this.shortFormProvider);
        object.accept((OWLObjectVisitor)visitor);
        return writer.getBuffer().toString();
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }
}

