/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;

class ExclusiveLongRangeCounter
extends LongRangeCounter {
    private final long[] boundaries;
    private final int[] rangeNums;
    private int missingCount;
    private boolean multiValuedDocMatchedRange;

    ExclusiveLongRangeCounter(LongRange[] ranges, int[] countBuffer) {
        super(countBuffer);
        LongRangeAndPos[] sortedRanges = new LongRangeAndPos[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            sortedRanges[i] = new LongRangeAndPos(ranges[i], i);
        }
        Arrays.sort(sortedRanges, Comparator.comparingLong(r -> r.range.min));
        List<LongRangeCounter.InclusiveRange> elementaryIntervals = ExclusiveLongRangeCounter.buildElementaryIntervals(sortedRanges);
        this.boundaries = new long[elementaryIntervals.size()];
        this.rangeNums = new int[elementaryIntervals.size()];
        Arrays.fill(this.rangeNums, -1);
        int currRange = 0;
        for (int i = 0; i < this.boundaries.length; ++i) {
            this.boundaries[i] = elementaryIntervals.get((int)i).end;
            if (currRange >= sortedRanges.length) continue;
            LongRangeAndPos curr = sortedRanges[currRange];
            if (this.boundaries[i] != curr.range.max) continue;
            this.rangeNums[i] = curr.pos;
            ++currRange;
        }
    }

    @Override
    void startMultiValuedDoc() {
        super.startMultiValuedDoc();
        this.multiValuedDocMatchedRange = false;
    }

    @Override
    boolean endMultiValuedDoc() {
        return this.multiValuedDocMatchedRange;
    }

    @Override
    void addSingleValued(long v) {
        if (this.rangeCount() == 0) {
            ++this.missingCount;
            return;
        }
        super.addSingleValued(v);
    }

    @Override
    int finish() {
        return this.missingCount;
    }

    @Override
    protected long[] boundaries() {
        return this.boundaries;
    }

    @Override
    protected void processSingleValuedHit(int elementaryIntervalNum) {
        int rangeNum = this.rangeNums[elementaryIntervalNum];
        if (rangeNum != -1) {
            this.increment(rangeNum);
        } else {
            ++this.missingCount;
        }
    }

    @Override
    protected void processMultiValuedHit(int elementaryIntervalNum) {
        int rangeNum = this.rangeNums[elementaryIntervalNum];
        if (rangeNum != -1) {
            this.increment(rangeNum);
            this.multiValuedDocMatchedRange = true;
        }
    }

    private static List<LongRangeCounter.InclusiveRange> buildElementaryIntervals(LongRangeAndPos[] sortedRanges) {
        ArrayList<LongRangeCounter.InclusiveRange> elementaryIntervals = new ArrayList<LongRangeCounter.InclusiveRange>();
        long prev = Long.MIN_VALUE;
        for (LongRangeAndPos range : sortedRanges) {
            if (range.range.min > prev) {
                elementaryIntervals.add(new LongRangeCounter.InclusiveRange(prev, range.range.min - 1L));
            }
            elementaryIntervals.add(new LongRangeCounter.InclusiveRange(range.range.min, range.range.max));
            prev = range.range.max + 1L;
        }
        if (!elementaryIntervals.isEmpty()) {
            long lastEnd = ((LongRangeCounter.InclusiveRange)elementaryIntervals.get((int)(elementaryIntervals.size() - 1))).end;
            if (lastEnd < Long.MAX_VALUE) {
                elementaryIntervals.add(new LongRangeCounter.InclusiveRange(lastEnd + 1L, Long.MAX_VALUE));
            }
        } else {
            elementaryIntervals.add(new LongRangeCounter.InclusiveRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        return elementaryIntervals;
    }

    private static final class LongRangeAndPos {
        final LongRange range;
        final int pos;

        LongRangeAndPos(LongRange range, int pos) {
            this.range = range;
            this.pos = pos;
        }
    }
}

