/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.InputStream;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

class JRubyAsciidoctorModuleFactory {
    protected RubyRuntimeAdapter evaler;
    private Ruby runtime;

    public JRubyAsciidoctorModuleFactory(Ruby runtime) {
        this.runtime = runtime;
        this.evaler = JavaEmbedUtils.newRuntimeAdapter();
    }

    public AsciidoctorModule createAsciidoctorModule() {
        String script = this.loadAsciidoctorRubyClass();
        this.evaler.eval(this.runtime, script);
        IRubyObject rfj = this.evaler.eval(this.runtime, "AsciidoctorModule.new()");
        return RubyUtils.rubyToJava(this.runtime, rfj, AsciidoctorModule.class);
    }

    private String loadAsciidoctorRubyClass() {
        InputStream inputStream = JRubyAsciidoctorModuleFactory.class.getResourceAsStream("asciidoctorclass.rb");
        return IOUtils.readFull(inputStream);
    }

    public Ruby runtime() {
        return this.runtime;
    }
}

