/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.filenaming;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.dependency.filenaming.AbstractDependencyFilenameStrategy;
import org.codehaus.mojo.webstart.dependency.filenaming.DependencyFilenameStrategy;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=DependencyFilenameStrategy.class, hint="simple")
public class SimpleDependencyFilenameStrategy
extends AbstractDependencyFilenameStrategy
implements DependencyFilenameStrategy {
    public static final String ROLE_HINT = "simple";

    public String getDependencyFileBasename(Artifact artifact, Boolean outputJarVersion) {
        String filename = artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            filename = filename + "-" + artifact.getClassifier();
        }
        if (outputJarVersion != null) {
            filename = outputJarVersion != false ? filename + "__V" : filename + "-";
            filename = filename + artifact.getVersion();
        }
        return filename;
    }
}

