/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.EmptyResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class MetaInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(MetaInfConfiguration.class);
    public static final String USE_CONTAINER_METAINF_CACHE = "org.eclipse.jetty.metainf.useCache";
    public static final boolean DEFAULT_USE_CONTAINER_METAINF_CACHE = true;
    public static final String CACHED_CONTAINER_TLDS = "org.eclipse.jetty.tlds.cache";
    public static final String CACHED_CONTAINER_FRAGMENTS = "org.eclipse.jetty.webFragments.cache";
    public static final String CACHED_CONTAINER_RESOURCES = "org.eclipse.jetty.resources.cache";
    public static final String METAINF_TLDS = "org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = "org.eclipse.jetty.webFragments";
    public static final String METAINF_RESOURCES = "org.eclipse.jetty.resources";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        boolean useContainerCache = true;
        Boolean attr = (Boolean)context.getServer().getAttribute(USE_CONTAINER_METAINF_CACHE);
        if (attr != null) {
            useContainerCache = attr;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} = {}", USE_CONTAINER_METAINF_CACHE, useContainerCache);
        }
        this.scanJars(context, context.getMetaData().getContainerResources(), useContainerCache);
        this.scanJars(context, context.getMetaData().getWebInfJars(), false);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches) throws Exception {
        ConcurrentHashMap<Resource, Resource> metaInfResourceCache = null;
        ConcurrentHashMap<Resource, Resource> metaInfFragmentCache = null;
        ConcurrentHashMap metaInfTldCache = null;
        if (useCaches) {
            metaInfResourceCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_RESOURCES);
            if (metaInfResourceCache == null) {
                metaInfResourceCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_RESOURCES, metaInfResourceCache);
            }
            if ((metaInfFragmentCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_FRAGMENTS)) == null) {
                metaInfFragmentCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_FRAGMENTS, metaInfFragmentCache);
            }
            if ((metaInfTldCache = (ConcurrentHashMap)context.getServer().getAttribute(CACHED_CONTAINER_TLDS)) == null) {
                metaInfTldCache = new ConcurrentHashMap();
                context.getServer().setAttribute(CACHED_CONTAINER_TLDS, metaInfTldCache);
            }
        }
        if (jars != null) {
            for (Resource r : jars) {
                this.scanForResources(context, r, metaInfResourceCache);
                this.scanForFragment(context, r, metaInfFragmentCache);
                this.scanForTlds(context, r, metaInfTldCache);
            }
        }
    }

    public void scanForResources(WebAppContext context, Resource target, ConcurrentHashMap<Resource, Resource> cache) throws Exception {
        HashSet<Resource> dirs;
        Resource resourcesDir = null;
        if (cache != null && cache.containsKey(target)) {
            resourcesDir = cache.get(target);
            if (resourcesDir == EmptyResource.INSTANCE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(target + " cached as containing no META-INF/resources", new Object[0]);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(target + " META-INF/resources found in cache ", new Object[0]);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(target + " META-INF/resources checked", new Object[0]);
            }
            if (target.isDirectory()) {
                resourcesDir = target.addPath("/META-INF/resources");
            } else {
                URI uri = target.getURI();
                resourcesDir = Resource.newResource("jar:" + uri + "!/META-INF/resources");
            }
            if (!resourcesDir.exists() || !resourcesDir.isDirectory()) {
                resourcesDir = EmptyResource.INSTANCE;
            }
            if (cache != null) {
                Resource old = cache.putIfAbsent(target, resourcesDir);
                if (old != null) {
                    resourcesDir = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(target + " META-INF/resources cache updated", new Object[0]);
                }
            }
            if (resourcesDir == EmptyResource.INSTANCE) {
                return;
            }
        }
        if ((dirs = (HashSet<Resource>)context.getAttribute(METAINF_RESOURCES)) == null) {
            dirs = new HashSet<Resource>();
            context.setAttribute(METAINF_RESOURCES, dirs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(resourcesDir + " added to context", new Object[0]);
        }
        dirs.add(resourcesDir);
    }

    public void scanForFragment(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Resource> cache) throws Exception {
        HashMap<Resource, Resource> fragments;
        Resource webFrag = null;
        if (cache != null && cache.containsKey(jar)) {
            webFrag = cache.get(jar);
            if (webFrag == EmptyResource.INSTANCE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " cached as containing no META-INF/web-fragment.xml", new Object[0]);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " META-INF/web-fragment.xml found in cache ", new Object[0]);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " META-INF/web-fragment.xml checked", new Object[0]);
            }
            if (jar.isDirectory()) {
                webFrag = jar.addPath("/META-INF/web-fragment.xml");
            } else {
                URI uri = jar.getURI();
                webFrag = Resource.newResource("jar:" + uri + "!/META-INF/web-fragment.xml");
            }
            if (!webFrag.exists() || webFrag.isDirectory()) {
                webFrag = EmptyResource.INSTANCE;
            }
            if (cache != null) {
                Resource old = cache.putIfAbsent(jar, webFrag);
                if (old != null) {
                    webFrag = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " META-INF/web-fragment.xml cache updated", new Object[0]);
                }
            }
            if (webFrag == EmptyResource.INSTANCE) {
                return;
            }
        }
        if ((fragments = (HashMap<Resource, Resource>)context.getAttribute(METAINF_FRAGMENTS)) == null) {
            fragments = new HashMap<Resource, Resource>();
            context.setAttribute(METAINF_FRAGMENTS, fragments);
        }
        fragments.put(jar, webFrag);
        if (LOG.isDebugEnabled()) {
            LOG.debug(webFrag + " added to context", new Object[0]);
        }
    }

    public void scanForTlds(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Collection<URL>> cache) throws Exception {
        Collection<URL> tlds = null;
        if (cache != null && cache.containsKey(jar)) {
            Collection<URL> tmp = cache.get(jar);
            if (tmp.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " cached as containing no tlds", new Object[0]);
                }
                return;
            }
            tlds = tmp;
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " tlds found in cache ", new Object[0]);
            }
        } else {
            Resource metaInfDir = null;
            if (jar.isDirectory()) {
                metaInfDir = jar.addPath("/META-INF/");
            } else {
                URI uri = jar.getURI();
                metaInfDir = Resource.newResource("jar:" + uri + "!/META-INF/");
            }
            tlds = new HashSet<URL>();
            Collection<Resource> resources = metaInfDir.getAllResources();
            for (Resource t : resources) {
                String name = t.toString();
                if (!name.endsWith(".tld")) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(t + " tld discovered", new Object[0]);
                }
                tlds.add(t.getURL());
            }
            if (cache != null) {
                Collection<URL> old;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " tld cache updated", new Object[0]);
                }
                if ((old = cache.putIfAbsent(jar, tlds)) != null) {
                    tlds = old;
                }
            }
            if (tlds.isEmpty()) {
                return;
            }
        }
        HashSet<URL> tld_resources = (HashSet<URL>)context.getAttribute(METAINF_TLDS);
        if (tld_resources == null) {
            tld_resources = new HashSet<URL>();
            context.setAttribute(METAINF_TLDS, tld_resources);
        }
        tld_resources.addAll(tlds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tlds added to context", new Object[0]);
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_RESOURCES, null);
        context.setAttribute(METAINF_TLDS, null);
    }
}

