/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.enrich.NamedPolicy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryBuilder;

public final class PutPolicyRequest
implements Validatable,
ToXContentObject {
    private final String name;
    private final String type;
    private BytesReference query;
    private final List<String> indices;
    private final String matchField;
    private final List<String> enrichFields;

    public PutPolicyRequest(String name, String type, List<String> indices, String matchField, List<String> enrichFields) {
        if (!Strings.hasLength((String)name)) {
            throw new IllegalArgumentException("name must be a non-null and non-empty string");
        }
        if (!Strings.hasLength((String)type)) {
            throw new IllegalArgumentException("type must be a non-null and non-empty string");
        }
        if (indices == null || indices.isEmpty()) {
            throw new IllegalArgumentException("indices must be specified");
        }
        if (!Strings.hasLength((String)matchField)) {
            throw new IllegalArgumentException("matchField must be a non-null and non-empty string");
        }
        if (enrichFields == null || enrichFields.isEmpty()) {
            throw new IllegalArgumentException("enrichFields must be specified");
        }
        this.name = name;
        this.type = type;
        this.indices = indices;
        this.matchField = matchField;
        this.enrichFields = enrichFields;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    public void setQuery(BytesReference query) {
        this.query = query;
    }

    public void setQuery(QueryBuilder query) throws IOException {
        this.setQuery(PutPolicyRequest.xContentToBytes((ToXContentObject)query));
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getMatchField() {
        return this.matchField;
    }

    public List<String> getEnrichFields() {
        return this.enrichFields;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.type);
        builder.field(NamedPolicy.INDICES_FIELD.getPreferredName(), this.indices);
        if (this.query != null) {
            builder.field(NamedPolicy.QUERY_FIELD.getPreferredName(), PutPolicyRequest.asMap(this.query, builder.contentType()));
        }
        builder.field(NamedPolicy.MATCH_FIELD_FIELD.getPreferredName(), this.matchField);
        builder.field(NamedPolicy.ENRICH_FIELDS_FIELD.getPreferredName(), this.enrichFields);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutPolicyRequest that = (PutPolicyRequest)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.query, that.query) && Objects.equals(this.indices, that.indices) && Objects.equals(this.matchField, that.matchField) && Objects.equals(this.enrichFields, that.enrichFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.query, this.indices, this.matchField, this.enrichFields);
    }

    private static BytesReference xContentToBytes(ToXContentObject object) throws IOException {
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            object.toXContent(builder, ToXContentObject.EMPTY_PARAMS);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    static Map<String, Object> asMap(BytesReference bytesReference, XContentType xContentType) {
        return bytesReference == null ? null : (Map)XContentHelper.convertToMap((BytesReference)bytesReference, (boolean)true, (XContentType)xContentType).v2();
    }
}

