/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMap;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogConfiguration
implements Configuration {
    private static Logger log = Logging.getLogger(CatalogConfiguration.class);
    private static Map<String, Response> cachedTileEncoders = new HashMap<String, Response>();
    private Catalog catalog;
    private CatalogLayerEventListener catalogLayerEventListener;
    private CatalogStyleChangeListener catalogStyleChangeListener;
    private final GWCConfigPersister configProvider;
    private final GridSetBroker gridSetBroker;
    private final WMS wmsFacade;

    public CatalogConfiguration(Catalog catalog, GWCConfigPersister configProvider, GridSetBroker gridSetBroker, WMS wmsFacade) {
        Assert.notNull((Object)catalog);
        Assert.notNull((Object)configProvider);
        Assert.notNull((Object)gridSetBroker);
        this.catalog = catalog;
        this.configProvider = configProvider;
        this.gridSetBroker = gridSetBroker;
        this.wmsFacade = wmsFacade;
        this.catalogLayerEventListener = new CatalogLayerEventListener(this);
        this.catalogStyleChangeListener = new CatalogStyleChangeListener(this);
        catalog.addListener((CatalogListener)this.catalogLayerEventListener);
        catalog.addListener((CatalogListener)this.catalogStyleChangeListener);
    }

    public String getIdentifier() {
        return "GeoServer Catalog Configuration";
    }

    private GWC getGWC() {
        return GWC.get();
    }

    public ServiceInformation getServiceInformation() {
        return null;
    }

    public boolean isRuntimeStatsEnabled() {
        return true;
    }

    public List<GeoServerTileLayer> getTileLayers() {
        List layerGroups = this.catalog.getLayerGroups();
        List layerInfos = this.catalog.getLayers();
        List[] sublists = new List[]{layerInfos, layerGroups};
        CompositeList composite = new CompositeList(sublists);
        LazyGeoServerTileLayerList tileLayers = new LazyGeoServerTileLayerList(composite, this);
        return tileLayers;
    }

    public Iterable<GeoServerTileLayer> getLayers() {
        return this.getTileLayers();
    }

    public Set<String> getTileLayerNames() {
        HashSet<String> names = new HashSet<String>();
        for (LayerGroupInfo lgi : this.catalog.getLayerGroups()) {
            names.add(lgi.getName());
        }
        for (LayerInfo li : this.catalog.getLayers()) {
            names.add(li.getResource().getPrefixedName());
        }
        return names;
    }

    public TileLayer getTileLayerById(String layerId) {
        LayerInfo layerInfo = this.catalog.getLayer(layerId);
        if (layerInfo != null) {
            return new GeoServerTileLayer(this, layerInfo);
        }
        LayerGroupInfo lgi = this.catalog.getLayerGroup(layerId);
        if (lgi != null) {
            return new GeoServerTileLayer(this, lgi);
        }
        return null;
    }

    public GeoServerTileLayer getTileLayer(String layerName) {
        LayerInfo layerInfo = this.catalog.getLayerByName(layerName);
        if (layerInfo != null) {
            return new GeoServerTileLayer(this, layerInfo);
        }
        LayerGroupInfo lgi = this.catalog.getLayerGroupByName(layerName);
        if (lgi != null) {
            return new GeoServerTileLayer(this, lgi);
        }
        return null;
    }

    public boolean containsLayer(String tileLayerId) {
        return this.getTileLayerById(tileLayerId) != null;
    }

    public int getTileLayerCount() {
        List layerGroups = this.catalog.getLayerGroups();
        List layerInfos = this.catalog.getLayers();
        int count = layerGroups.size() + layerInfos.size();
        return count;
    }

    public boolean remove(String layerName) {
        return false;
    }

    public GWCConfig getConfig() {
        return this.configProvider.getConfig();
    }

    public GridSetBroker getGridSetBroker() {
        return this.gridSetBroker;
    }

    public void save(GeoServerTileLayer layer) {
        log.info("Saving " + layer.getName());
        LayerInfo layerInfo = layer.getLayerInfo();
        LayerGroupInfo layerGroupInfo = layer.getLayerGroupInfo();
        MetadataMap metadata = layerInfo == null ? layerGroupInfo.getMetadata() : layerInfo.getMetadata();
        GeoServerTileLayerInfo tileLayerInfo = layer.getInfo();
        tileLayerInfo.saveTo(metadata);
        if (layerInfo != null) {
            this.catalog.save(layerInfo);
        } else {
            this.catalog.save(layerGroupInfo);
        }
    }

    public boolean isQueryable(GeoServerTileLayer geoServerTileLayer) {
        LayerInfo layerInfo = geoServerTileLayer.getLayerInfo();
        if (layerInfo != null) {
            return this.wmsFacade.isQueryable(layerInfo);
        }
        LayerGroupInfo lgi = geoServerTileLayer.getLayerGroupInfo();
        return this.wmsFacade.isQueryable(lgi);
    }

    public Resource dispatchOwsRequest(Map<String, String> params, Cookie[] cookies) throws Exception {
        return this.getGWC().dispatchOwsRequest(params, cookies);
    }

    public LayerInfo getLayerInfoById(String layerId) {
        return this.catalog.getLayer(layerId);
    }

    public LayerGroupInfo getLayerGroupById(String layerGroupId) {
        return this.catalog.getLayerGroup(layerGroupId);
    }

    public void renameTileLayer(String oldLayerName, String newLayerName) {
        this.getGWC().layerRenamed(oldLayerName, newLayerName);
    }

    public void truncate(String layerName, String styleName) {
        this.getGWC().truncate(layerName, styleName);
    }

    public void truncate(String layerName) {
        this.getGWC().truncate(layerName);
    }

    public boolean removeLayer(String tileLayerName) {
        this.getGWC().layerRemoved(tileLayerName);
        return true;
    }

    public void createLayer(LayerInfo layerInfo) {
        GeoServerTileLayer tileLayer = new GeoServerTileLayer(this, layerInfo);
        this.save(tileLayer);
        this.getGWC().layerAdded(tileLayer);
    }

    public void createLayer(LayerGroupInfo lgi) {
        GeoServerTileLayer tileLayer = new GeoServerTileLayer(this, lgi);
        this.save(tileLayer);
        this.getGWC().layerAdded(tileLayer);
    }

    public List<GeoServerTileLayer> getTileLayersForStyle(String styleName) {
        List<GeoServerTileLayer> tileLayers = this.getTileLayers();
        ArrayList<GeoServerTileLayer> affected = new ArrayList<GeoServerTileLayer>();
        for (GeoServerTileLayer tl : tileLayers) {
            GeoServerTileLayerInfo info = tl.getInfo();
            String defaultStyle = tl.getStyles();
            Set<String> cachedStyles = info.getCachedStyles();
            if (!styleName.equals(defaultStyle) && !cachedStyles.contains(styleName)) continue;
            affected.add(tl);
        }
        return affected;
    }

    public Iterable<LayerInfo> getLayerInfosFor(StyleInfo style) {
        String styleName = style.getName();
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        List layers = this.catalog.getLayers();
        block0: for (LayerInfo layer : layers) {
            String name = layer.getDefaultStyle().getName();
            if (styleName.equals(name)) {
                result.add(layer);
                continue;
            }
            for (StyleInfo alternateStyle : layer.getStyles()) {
                name = alternateStyle.getName();
                if (!styleName.equals(name)) continue;
                result.add(layer);
                continue block0;
            }
        }
        return result;
    }

    public Iterable<LayerGroupInfo> getLayerGroupsFor(StyleInfo style) {
        ArrayList<LayerGroupInfo> layerGroups = new ArrayList<LayerGroupInfo>();
        block0: for (LayerGroupInfo layerGroup : this.catalog.getLayerGroups()) {
            List explicitLayerGroupStyles = layerGroup.getStyles();
            List groupLayers = layerGroup.getLayers();
            int layerN = 0;
            while (layerN < groupLayers.size()) {
                LayerInfo childLayer = (LayerInfo)groupLayers.get(layerN);
                StyleInfo assignedLayerStyle = (StyleInfo)explicitLayerGroupStyles.get(layerN);
                if (assignedLayerStyle == null) {
                    assignedLayerStyle = childLayer.getDefaultStyle();
                }
                if (style.equals(assignedLayerStyle)) {
                    layerGroups.add(layerGroup);
                    continue block0;
                }
                ++layerN;
            }
        }
        return layerGroups;
    }

    public int initialize(GridSetBroker gridSetBroker) throws GeoWebCacheException {
        return this.getTileLayerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponseEncoder(MimeType responseFormat, WebMap webMap) {
        String format = responseFormat.getFormat();
        String mimeType = responseFormat.getMimeType();
        Response response = cachedTileEncoders.get(format);
        if (response == null) {
            GetMapRequest getMap = new GetMapRequest();
            getMap.setFormat(mimeType);
            Object[] parameters = new Object[]{getMap};
            Service service = (Service)GeoServerExtensions.bean((String)"wms-1_1_1-ServiceDescriptor");
            if (service == null) {
                throw new IllegalStateException("Didn't find service descriptor 'wms-1_1_1-ServiceDescriptor'");
            }
            Operation operation = new Operation("GetMap", service, null, parameters);
            List extensions = GeoServerExtensions.extensions(Response.class);
            Class<?> webMapClass = webMap.getClass();
            for (Response r : extensions) {
                if (!r.getBinding().isAssignableFrom(webMapClass) || !r.canHandle(operation)) continue;
                Map<String, Response> map = cachedTileEncoders;
                synchronized (map) {
                    cachedTileEncoders.put(mimeType, r);
                    response = r;
                    break;
                }
            }
            if (response == null) {
                throw new IllegalStateException("Didn't find a " + Response.class.getName() + " to handle " + mimeType);
            }
        }
        return response;
    }

    public void modifyLayer(TileLayer tl) throws NoSuchElementException {
    }

    public void save() throws IOException {
    }

    public boolean canSave(TileLayer tl) {
        return false;
    }

    public void addLayer(TileLayer tl) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeList
    extends AbstractList<Object> {
        private final List<Object>[] decorated;

        public CompositeList(List[] sublists) {
            this.decorated = sublists;
        }

        @Override
        public Object get(int index) {
            int subIndex = index;
            int i = 0;
            while (i < this.decorated.length) {
                List<Object> sublist = this.decorated[i];
                if (subIndex < sublist.size()) {
                    return sublist.get(subIndex);
                }
                subIndex -= sublist.size();
                ++i;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            int size = 0;
            int i = 0;
            while (i < this.decorated.length) {
                List<Object> sublist = this.decorated[i];
                size += sublist.size();
                ++i;
            }
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyGeoServerTileLayerList
    extends AbstractList<GeoServerTileLayer> {
        private final List<Object> infos;
        private final CatalogConfiguration mediator;

        public LazyGeoServerTileLayerList(List<Object> infos, CatalogConfiguration catalogConfiguration) {
            this.infos = infos;
            this.mediator = catalogConfiguration;
        }

        @Override
        public GeoServerTileLayer get(int index) {
            Object object = this.infos.get(index);
            if (object instanceof LayerInfo) {
                return new GeoServerTileLayer(this.mediator, (LayerInfo)object);
            }
            if (object instanceof LayerGroupInfo) {
                return new GeoServerTileLayer(this.mediator, (LayerGroupInfo)object);
            }
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return this.infos.size();
        }
    }
}

