/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.ows.Response;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.crop.GTCropDescriptor;
import org.geotools.resources.i18n.Errors;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;
import org.springframework.util.Assert;

public class GeoServerMetaTile
extends MetaTile {
    private RenderedImageMap metaTileMap;
    private final String layer;
    private final CatalogConfiguration mediator;

    public GeoServerMetaTile(String layer, GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY, Integer gutter, CatalogConfiguration mediator) {
        super(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, gutter);
        this.layer = layer;
        this.mediator = mediator;
    }

    public void setWebMap(RenderedImageMap webMap) {
        this.metaTileMap = webMap;
        if (webMap instanceof RenderedImageMap) {
            this.setImage(webMap.getImage());
        }
    }

    public boolean writeTileToStream(int tileIdx, Resource target) throws IOException {
        Assert.notNull((Object)this.metaTileMap, (String)"webMap is not set");
        if (!(this.metaTileMap instanceof RenderedImageMap)) {
            throw new IllegalArgumentException("Only RenderedImageMaps are supported so far: " + this.metaTileMap.getClass().getName());
        }
        Response responseEncoder = this.mediator.getResponseEncoder(this.responseFormat, (WebMap)this.metaTileMap);
        RenderedImageMapResponse mapEncoder = (RenderedImageMapResponse)responseEncoder;
        RenderedImage tile = this.metaTileMap.getImage();
        WMSMapContext tileContext = this.metaTileMap.getMapContext();
        if (this.tiles.length > 1) {
            Rectangle tileDim = this.tiles[tileIdx];
            tile = this.createTile(tileDim.x, tileDim.y, tileDim.width, tileDim.height);
            this.disposeLater(tile);
            WMSMapContext metaTileContext = this.metaTileMap.getMapContext();
            tileContext = new WMSMapContext();
            tileContext.setRequest(metaTileContext.getRequest());
            tileContext.setBgColor(metaTileContext.getBgColor());
            tileContext.setMapWidth(tileDim.width);
            tileContext.setMapHeight(tileDim.height);
            tileContext.setPaletteInverter(metaTileContext.getPaletteInverter());
            tileContext.setTransparent(tileContext.isTransparent());
            long[][] tileIndexes = this.getTilesGridPositions();
            BoundingBox tileBounds = this.gridSubset.boundsFromIndex(tileIndexes[tileIdx]);
            ReferencedEnvelope tilebbox = new ReferencedEnvelope(metaTileContext.getCoordinateReferenceSystem());
            tilebbox.init(tileBounds.getMinX(), tileBounds.getMaxX(), tileBounds.getMinY(), tileBounds.getMaxY());
            tileContext.getViewport().setBounds(tilebbox);
        }
        OutputStream outStream = target.getOutputStream();
        try {
            mapEncoder.formatImageOutputStream(tile, outStream, tileContext);
            return true;
        }
        finally {
            outStream.close();
        }
    }

    public RenderedImage createTile(int x, int y, int tileWidth, int tileHeight) {
        BufferedImage tile;
        int type = this.metaTileImage instanceof PlanarImage ? 1 : (this.metaTileImage instanceof BufferedImage ? 2 : 0);
        switch (type) {
            case 0: {
                RenderedOp cropped = GTCropDescriptor.create((RenderedImage)this.metaTileImage, (Float)Float.valueOf(x), (Float)Float.valueOf(y), (Float)Float.valueOf(tileWidth), (Float)Float.valueOf(tileHeight), (RenderingHints)NO_CACHE);
                tile = cropped.getAsBufferedImage();
                this.disposeLater((RenderedImage)cropped);
                break;
            }
            case 1: {
                PlanarImage pImage = (PlanarImage)this.metaTileImage;
                WritableRaster wTile = WritableRaster.createWritableRaster(pImage.getSampleModel().createCompatibleSampleModel(tileWidth, tileHeight), new Point(x, y));
                Rectangle sourceArea = new Rectangle(x, y, tileWidth, tileHeight);
                sourceArea = sourceArea.intersection(pImage.getBounds());
                pImage.copyData(wTile);
                if (wTile.getMinX() != 0 || wTile.getMinY() != 0) {
                    tile = new BufferedImage(pImage.getColorModel(), (WritableRaster)wTile.createTranslatedChild(0, 0), pImage.getColorModel().isAlphaPremultiplied(), null);
                    break;
                }
                tile = new BufferedImage(pImage.getColorModel(), wTile, pImage.getColorModel().isAlphaPremultiplied(), null);
                break;
            }
            case 2: {
                BufferedImage image = (BufferedImage)this.metaTileImage;
                tile = image.getSubimage(x, y, tileWidth, tileHeight);
                break;
            }
            default: {
                throw new IllegalStateException(Errors.format((int)58, (Object)"metaTile class", (Object)this.metaTileImage.getClass().toString()));
            }
        }
        return tile;
    }

    public void dispose() {
        if (this.metaTileMap != null) {
            this.metaTileMap.dispose();
            this.metaTileMap = null;
        }
        super.dispose();
    }
}

