/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerMetaTile;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.CanonicalSet;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.GridLocObj;
import org.geowebcache.layer.LayerListenerList;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.ServletUtils;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerTileLayer
extends TileLayer {
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayer.class);
    private final GeoServerTileLayerInfo info;
    public static final String GWC_SEED_INTERCEPT_TOKEN = "GWC_SEED_INTERCEPT";
    public static final ThreadLocal<WebMap> WEB_MAP = new ThreadLocal();
    private CatalogConfiguration mediator;
    private final String layerId;
    private final String layerGroupId;
    private String configErrorMessage;
    private List<ParameterFilter> parameterFilters;
    private Map<String, GridSubset> subSets;
    private static LayerListenerList listeners = new LayerListenerList();
    private static final CanonicalSet<GridLocObj> META_GRID_LOCKS = CanonicalSet.newInstance(GridLocObj.class);

    public GeoServerTileLayer(CatalogConfiguration mediator, LayerGroupInfo layerGroup) {
        this.mediator = mediator;
        this.layerId = null;
        this.layerGroupId = layerGroup.getId();
        GWCConfig configDefaults = mediator.getConfig();
        this.info = GeoServerTileLayerInfo.create(layerGroup, configDefaults);
    }

    public GeoServerTileLayer(CatalogConfiguration mediator, LayerInfo layerInfo) {
        this.mediator = mediator;
        this.layerId = layerInfo.getId();
        this.layerGroupId = null;
        GWCConfig configDefaults = mediator.getConfig();
        this.info = GeoServerTileLayerInfo.create(layerInfo, configDefaults);
    }

    public String getId() {
        if (this.layerGroupId != null) {
            return this.layerGroupId;
        }
        return this.layerId;
    }

    public String getName() {
        if (this.layerGroupId != null) {
            LayerGroupInfo layerGroupInfo = this.getLayerGroupInfo();
            return layerGroupInfo.getName();
        }
        LayerInfo layerInfo = this.getLayerInfo();
        ResourceInfo resource = layerInfo.getResource();
        return resource.getPrefixedName();
    }

    void setConfigErrorMessage(String configErrorMessage) {
        this.configErrorMessage = configErrorMessage;
    }

    public String getConfigErrorMessage() {
        return this.configErrorMessage;
    }

    public List<ParameterFilter> getParameterFilters() {
        Set<String> cachedStyles;
        if (this.parameterFilters == null && (cachedStyles = this.info.getCachedStyles()).size() > 0) {
            String defaultStyle = this.getStyles();
            if (defaultStyle == null) {
                throw new IllegalStateException("TileLayer backed by a LayerGroup should not have alternate styles!");
            }
            StringParameterFilter stylesParameterFilter = GeoServerTileLayer.createStylesParameterFilters(defaultStyle, cachedStyles);
            if (stylesParameterFilter != null) {
                LOGGER.fine("Created STYLES parameter filter for layer " + this.getName() + " and styles " + stylesParameterFilter.getLegalValues());
                List<ParameterFilter> paramFilters = Arrays.asList(stylesParameterFilter);
                this.parameterFilters = paramFilters;
            }
        }
        return this.parameterFilters;
    }

    public void resetParameterFilters() {
        this.defaultParameterFilterValues = null;
        this.parameterFilters = null;
    }

    public boolean isEnabled() {
        boolean tileLayerInfoEnabled = this.info.isEnabled();
        if (!tileLayerInfoEnabled) {
            return false;
        }
        if (this.getConfigErrorMessage() != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Layer " + this.getName() + "is not enabled due to config error: " + this.getConfigErrorMessage());
            }
            return false;
        }
        LayerInfo layerInfo = this.getLayerInfo();
        boolean geoserverLayerEnabled = layerInfo != null ? layerInfo.enabled() : true;
        return tileLayerInfoEnabled && geoserverLayerEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldVal = this.info.isEnabled();
        this.info.setEnabled(enabled);
        if (oldVal != enabled) {
            this.mediator.save(this);
        }
    }

    public boolean isQueryable() {
        return this.mediator.isQueryable(this);
    }

    private ReferencedEnvelope getLatLonBbox() throws IllegalStateException {
        ReferencedEnvelope latLongBbox;
        CoordinateReferenceSystem wgs84LonFirst;
        try {
            boolean longitudeFirst = true;
            wgs84LonFirst = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.getLayerInfo() == null) {
            LayerGroupInfo groupInfo = this.getLayerGroupInfo();
            try {
                ReferencedEnvelope bounds = groupInfo.getBounds();
                boolean lenient = true;
                latLongBbox = bounds.transform(wgs84LonFirst, lenient);
            }
            catch (Exception e) {
                String msg = "Can't get lat long bounds for layer group " + groupInfo.getName();
                LOGGER.log(Level.WARNING, msg, e);
                throw new IllegalStateException(msg, e);
            }
        } else {
            ResourceInfo resourceInfo = this.getResourceInfo();
            latLongBbox = resourceInfo.getLatLonBoundingBox();
            if (latLongBbox == null) {
                latLongBbox = new ReferencedEnvelope(wgs84LonFirst);
            }
            if (latLongBbox.getCoordinateReferenceSystem() == null) {
                ReferencedEnvelope tmp = new ReferencedEnvelope(wgs84LonFirst);
                tmp.init(latLongBbox.getMinX(), latLongBbox.getMaxX(), latLongBbox.getMinY(), latLongBbox.getMaxY());
                latLongBbox = tmp;
            }
        }
        return latLongBbox;
    }

    public static StringParameterFilter createStylesParameterFilters(String defaultStyle, Set<String> styleNames) {
        Assert.notNull((Object)defaultStyle, (String)"defaultStyle");
        Assert.notNull((Object)defaultStyle, (String)"alternate styles");
        if (styleNames.size() == 0) {
            return null;
        }
        TreeSet<String> possibleValues = new TreeSet<String>();
        possibleValues.add(defaultStyle);
        possibleValues.addAll(styleNames);
        StringParameterFilter styleParamFilter = new StringParameterFilter();
        styleParamFilter.setKey("STYLES");
        styleParamFilter.setDefaultValue(defaultStyle);
        styleParamFilter.getValues().addAll(possibleValues);
        return styleParamFilter;
    }

    public LayerInfo getLayerInfo() {
        if (this.layerId == null) {
            return null;
        }
        LayerInfo layerInfo = this.mediator.getLayerInfoById(this.layerId);
        return layerInfo;
    }

    public LayerGroupInfo getLayerGroupInfo() {
        if (this.layerGroupId == null) {
            return null;
        }
        LayerGroupInfo layerGroupInfo = this.mediator.getLayerGroupById(this.layerGroupId);
        return layerGroupInfo;
    }

    private ResourceInfo getResourceInfo() {
        LayerInfo layerInfo = this.getLayerInfo();
        return layerInfo == null ? null : layerInfo.getResource();
    }

    public LayerMetaInformation getMetaInformation() {
        LayerMetaInformation meta = null;
        String title = this.getName();
        String description = "";
        List keywords = Collections.emptyList();
        List contacts = Collections.emptyList();
        ResourceInfo resourceInfo = this.getResourceInfo();
        if (resourceInfo != null) {
            title = resourceInfo.getTitle();
            description = resourceInfo.getAbstract();
            keywords = new ArrayList();
            for (KeywordInfo kw : resourceInfo.getKeywords()) {
                keywords.add(kw.getValue());
            }
        }
        meta = new LayerMetaInformation(title, description, keywords, contacts);
        return meta;
    }

    public String getStyles() {
        if (this.layerGroupId != null) {
            return null;
        }
        LayerInfo layerInfo = this.getLayerInfo();
        StyleInfo defaultStyle = layerInfo.getDefaultStyle();
        if (defaultStyle == null) {
            this.setConfigErrorMessage("Underlying GeoSever Layer has no default style");
            return null;
        }
        return defaultStyle.getName();
    }

    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        Resource response;
        Map<String, String> params = this.buildGetFeatureInfo(convTile, bbox, height, width, x, y);
        try {
            response = this.mediator.dispatchOwsRequest(params, null);
        }
        catch (Exception e) {
            throw new GeoWebCacheException((Throwable)e);
        }
        return response;
    }

    private Map<String, String> buildGetFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) {
        Map fullParameters;
        HashMap<String, String> wmsParams = new HashMap<String, String>();
        wmsParams.put("SERVICE", "WMS");
        wmsParams.put("VERSION", "1.1.1");
        wmsParams.put("REQUEST", "GetFeatureInfo");
        wmsParams.put("LAYERS", this.getName());
        wmsParams.put("STYLES", "");
        wmsParams.put("QUERY_LAYERS", this.getName());
        MimeType mimeType = convTile.getMimeType();
        if (mimeType == null) {
            mimeType = this.getMimeTypes().get(0);
        }
        wmsParams.put("FORMAT", mimeType.getFormat());
        wmsParams.put("EXCEPTIONS", "SE_XML");
        wmsParams.put("INFO_FORMAT", convTile.getMimeType().getFormat());
        GridSubset gridSubset = convTile.getGridSubset();
        wmsParams.put("SRS", gridSubset.getSRS().toString());
        wmsParams.put("HEIGHT", String.valueOf(height));
        wmsParams.put("WIDTH", String.valueOf(width));
        wmsParams.put("BBOX", bbox.toString());
        wmsParams.put("X", String.valueOf(x));
        wmsParams.put("Y", String.valueOf(y));
        Map values = ServletUtils.selectedStringsFromMap((Map)convTile.servletReq.getParameterMap(), (String)convTile.servletReq.getCharacterEncoding(), (String[])new String[]{"feature_count"});
        String featureCount = (String)values.get("feature_count");
        if (featureCount != null) {
            wmsParams.put("FEATURE_COUNT", featureCount);
        }
        if ((fullParameters = convTile.getFullParameters()).isEmpty()) {
            fullParameters = this.getDefaultParameterFilters();
        }
        wmsParams.putAll(fullParameters);
        return wmsParams;
    }

    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
        int metaY;
        int metaX;
        MimeType mime = tile.getMimeType();
        List<MimeType> formats = this.getMimeTypes();
        if (mime == null) {
            mime = formats.get(0);
        } else if (!formats.contains(mime)) {
            throw new IllegalArgumentException(String.valueOf(mime.getFormat()) + " is not a supported format for " + this.getName());
        }
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        if (gridSubset == null) {
            throw new IllegalArgumentException("Requested gridset not found: " + tileGridSetId);
        }
        long[] gridLoc = tile.getTileIndex();
        Assert.notNull((Object)gridLoc);
        gridSubset.checkCoverage(gridLoc);
        if (mime.supportsTiling()) {
            metaX = this.info.getMetaTilingX();
            metaY = this.info.getMetaTilingY();
        } else {
            metaY = 1;
            metaX = 1;
        }
        ConveyorTile returnTile = this.getMetatilingReponse(tile, true, metaX, metaY);
        this.sendTileRequestedEvent(returnTile);
        return returnTile;
    }

    public void addLayerListener(TileLayerListener listener) {
        listeners.addListener(listener);
    }

    public boolean removeLayerListener(TileLayerListener listener) {
        listeners.removeListener(listener);
        return true;
    }

    protected final void sendTileRequestedEvent(ConveyorTile tile) {
        if (listeners != null) {
            listeners.sendTileRequested((TileLayer)this, tile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getMetatilingReponse(ConveyorTile tile, boolean tryCache, int metaX, int metaY) throws GeoWebCacheException, IOException {
        GridLocObj metaGridLoc;
        if (tryCache && this.tryCacheFetch(tile)) {
            return this.finalizeTile(tile);
        }
        GeoServerMetaTile metaTile = this.createMetaTile(tile, metaX, metaY);
        GridLocObj gridLocObj = metaGridLoc = (GridLocObj)META_GRID_LOCKS.unique((Object)new GridLocObj(metaTile.getMetaGridPos(), 32));
        synchronized (gridLocObj) {
            if (tryCache && this.tryCacheFetch(tile)) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("--> " + Thread.currentThread().getName() + " returns cache hit for " + Arrays.toString(metaTile.getMetaGridPos()));
                }
            } else {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("--> " + Thread.currentThread().getName() + " submitting getMap request for meta grid location " + Arrays.toString(metaTile.getMetaGridPos()) + " on " + (Object)((Object)metaTile));
                }
                try {
                    try {
                        RenderedImageMap map = this.dispatchGetMap(tile, metaTile);
                        Assert.notNull((Object)map, (String)"Did not obtain a WebMap from GeoServer's Dispatcher");
                        metaTile.setWebMap(map);
                        this.saveTiles(metaTile, tile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new GeoWebCacheException("Problem communicating with GeoServer", (Throwable)e);
                    }
                }
                finally {
                    META_GRID_LOCKS.remove((Object)metaGridLoc);
                    metaTile.dispose();
                }
            }
        }
        return this.finalizeTile(tile);
    }

    private RenderedImageMap dispatchGetMap(ConveyorTile tile, MetaTile metaTile) throws Exception {
        WebMap map;
        Map<String, String> params = this.buildGetMap(tile, metaTile);
        try {
            HttpServletRequest actualRequest = tile.servletReq;
            Cookie[] cookies = actualRequest == null ? null : actualRequest.getCookies();
            this.mediator.dispatchOwsRequest(params, cookies);
            map = WEB_MAP.get();
            if (!(map instanceof RenderedImageMap)) {
                throw new IllegalStateException("Expected: RenderedImageMap, got " + map);
            }
        }
        finally {
            WEB_MAP.remove();
        }
        return (RenderedImageMap)map;
    }

    private GeoServerMetaTile createMetaTile(ConveyorTile tile, int metaX, int metaY) {
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        MimeType responseFormat = tile.getMimeType();
        FormatModifier formatModifier = null;
        long[] tileGridPosition = tile.getTileIndex();
        int gutter = this.info.getGutter();
        String layerName = this.getName();
        GeoServerMetaTile metaTile = new GeoServerMetaTile(layerName, gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, gutter, this.mediator);
        return metaTile;
    }

    private Map<String, String> buildGetMap(ConveyorTile tile, MetaTile metaTile) throws ParameterException {
        HashMap<String, String> params = new HashMap<String, String>();
        MimeType mimeType = tile.getMimeType();
        String gridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(gridSetId);
        int width = metaTile.getMetaTileWidth();
        int height = metaTile.getMetaTileHeight();
        String srs = gridSubset.getSRS().toString();
        String format = mimeType.getFormat();
        BoundingBox bbox = metaTile.getMetaTileBounds();
        params.put("SERVICE", "WMS");
        params.put("VERSION", "1.1.1");
        params.put("REQUEST", "GetMap");
        params.put("LAYERS", this.getName());
        params.put("SRS", srs);
        params.put("FORMAT", format);
        params.put("WIDTH", String.valueOf(width));
        params.put("HEIGHT", String.valueOf(height));
        params.put("BBOX", bbox.toString());
        params.put("EXCEPTIONS", "SE_XML");
        params.put("STYLES", "");
        params.put("TRANSPARENT", "true");
        params.put(GWC_SEED_INTERCEPT_TOKEN, "true");
        Map filteredParams = tile.getFullParameters();
        if (filteredParams.isEmpty()) {
            filteredParams = this.getDefaultParameterFilters();
        }
        params.putAll(filteredParams);
        return params;
    }

    private boolean tryCacheFetch(ConveyorTile tile) {
        int expireCache = this.getExpireCache((int)tile.getTileIndex()[2]);
        if (expireCache != -1) {
            try {
                return tile.retrieve((long)expireCache * 1000L);
            }
            catch (GeoWebCacheException gwce) {
                LOGGER.info(gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile.servletResp != null) {
            this.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            this.setTileIndexHeader(tile);
        }
        return tile;
    }

    private void setTileIndexHeader(ConveyorTile tile) {
        tile.servletResp.addHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
    }

    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingReponse(tile, false, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingReponse(tile, true, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        int metaX = this.info.getMetaTilingX();
        int metaY = this.info.getMetaTilingY();
        if (!tile.getMimeType().supportsTiling()) {
            metaY = 1;
            metaX = 1;
        }
        this.getMetatilingReponse(tile, tryCache, metaX, metaY);
    }

    public void acquireLayerLock() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void releaseLayerLock() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    private Map<String, GridSubset> getGrids(ReferencedEnvelope latLonBbox, GridSetBroker gridSetBroker) throws ConfigurationException {
        Set<String> cachedGridSetIds = this.info.getCachedGridSetIds();
        if (cachedGridSetIds.size() == 0) {
            throw new IllegalStateException("TileLayer " + this.getName() + " has no gridsets configured");
        }
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>(2);
        for (String gridSetId : cachedGridSetIds) {
            GridSet gridSet = gridSetBroker.get(gridSetId);
            if (gridSet == null) {
                throw new ConfigurationException("No GWC GridSet named '" + gridSetId + "' exists.");
            }
            BoundingBox extent = this.getBoundsFromWGS84Bounds(latLonBbox, gridSet.getSrs());
            Integer zoomStart = 0;
            Integer zoomStop = gridSet.getGridLevels().length - 1;
            GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)extent, (Integer)zoomStart, (Integer)zoomStop);
            grids.put(gridSetId, gridSubSet);
        }
        return grids;
    }

    private BoundingBox getBoundsFromWGS84Bounds(ReferencedEnvelope latLonBbox, SRS srs) {
        BoundingBox bounds;
        Assert.notNull((Object)latLonBbox);
        Assert.notNull((Object)latLonBbox.getCoordinateReferenceSystem());
        Assert.notNull((Object)srs);
        double minX = latLonBbox.getMinX();
        double minY = latLonBbox.getMinY();
        double maxX = latLonBbox.getMaxX();
        double maxY = latLonBbox.getMaxY();
        String epsgCode = srs.toString();
        boolean longitudeFirst = true;
        if ("EPSG:900913".equals(epsgCode) || "EPSG:3857".equals(epsgCode)) {
            bounds = new BoundingBox(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
        } else {
            ReferencedEnvelope transformedBounds;
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)epsgCode, (boolean)true);
                Assert.notNull((Object)crs);
                transformedBounds = latLonBbox.transform(crs, true, 20);
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new RuntimeException(e);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            bounds = new BoundingBox(transformedBounds.getMinX(), transformedBounds.getMinY(), transformedBounds.getMaxX(), transformedBounds.getMaxY());
        }
        return bounds;
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        double tmp = 0.7853981633974483 + (y *= Math.PI / 180) / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }

    public GeoServerTileLayerInfo getInfo() {
        return this.info;
    }

    public Set<String> getGridSubsets() {
        if (this.subSets == null) {
            ReferencedEnvelope latLongBbox = this.getLatLonBbox();
            try {
                GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
                this.subSets = this.getGrids(latLongBbox, gridSetBroker);
            }
            catch (ConfigurationException e) {
                String msg = "Can't create grids for '" + this.getName() + "': " + e.getMessage();
                LOGGER.log(Level.WARNING, msg, e);
                this.setConfigErrorMessage(msg);
                return Collections.emptySet();
            }
        }
        return new HashSet<String>(this.subSets.keySet());
    }

    public GridSubset getGridSubset(String gridSetId) {
        if (!this.getGridSubsets().contains(gridSetId)) {
            return null;
        }
        return this.subSets.get(gridSetId);
    }

    public GridSubset removeGridSubset(String gridSetId) {
        throw new UnsupportedOperationException("not yet implemented nor used");
    }

    public void addGridSubset(GridSubset gridSubset) {
        throw new UnsupportedOperationException("not yet implemented nor used");
    }

    public List<UpdateSourceDefinition> getUpdateSources() {
        return Collections.emptyList();
    }

    public boolean useETags() {
        return false;
    }

    public List<FormatModifier> getFormatModifiers() {
        return Collections.emptyList();
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        throw new UnsupportedOperationException();
    }

    public int[] getMetaTilingFactors() {
        return new int[]{this.info.getMetaTilingX(), this.info.getMetaTilingY()};
    }

    public Boolean isCacheBypassAllowed() {
        return true;
    }

    public void setCacheBypassAllowed(boolean allowed) {
        throw new UnsupportedOperationException();
    }

    public Integer getBackendTimeout() {
        return 0;
    }

    public void setBackendTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    public List<MimeType> getMimeTypes() {
        Set<String> mimeFormats = this.info.getMimeFormats();
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>(mimeFormats.size());
        for (String format : mimeFormats) {
            try {
                mimeTypes.add(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                LOGGER.log(Level.WARNING, "Can't create MimeType from format " + format, e);
            }
        }
        return mimeTypes;
    }

    public int getExpireClients(int zoomLevel) {
        return 0;
    }

    public int getExpireCache(int zoomLevel) {
        return 0;
    }

    public List<RequestFilter> getRequestFilters() {
        return null;
    }

    public boolean initialize(GridSetBroker gridSetBroker) {
        return true;
    }
}

