/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Iterator;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWCCatalogListener;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;

public class GWCCatalogListenerTest
extends GeoServerTestSupport {
    public void testInit() throws Exception {
        GWCCatalogListener gwcListener = (GWCCatalogListener)applicationContext.getBean("gwcCatalogListener");
        Catalog cat = gwcListener.cat;
        TileLayerDispatcher tld = gwcListener.layerDispatcher;
        try {
            tld.getTileLayer("");
        }
        catch (GeoWebCacheException gwce) {
            // empty catch block
        }
        List layerList = gwcListener.getTileLayers(true);
        Iterator tlIter = layerList.iterator();
        GWCCatalogListenerTest.assertTrue((boolean)tlIter.hasNext());
        boolean foundLakes = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            if (!tl.getName().equals("cite:Lakes")) continue;
            foundLakes = true;
            break;
        }
        GWCCatalogListenerTest.assertTrue((boolean)foundLakes);
        boolean foudAGF = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            System.out.println(tl.getName());
            if (!tl.getName().equals("sf:AggregateGeoFeature")) continue;
            foudAGF = true;
            GridSubset epsg4326 = tl.getGridSubset(gwcListener.gridSetBroker.WORLD_EPSG4326.getName());
            GWCCatalogListenerTest.assertTrue((boolean)epsg4326.getGridSetBounds().equals((Object)new BoundingBox(-180.0, -90.0, 180.0, 90.0)));
            String mime = ((MimeType)tl.getMimeTypes().get(1)).getMimeType();
            GWCCatalogListenerTest.assertTrue((mime.startsWith("image/") || mime.startsWith("application/vnd.google-earth.kml+xml") ? 1 : 0) != 0);
        }
        GWCCatalogListenerTest.assertTrue((boolean)foudAGF);
        LayerInfo li = (LayerInfo)cat.getLayers().get(1);
        String layerName = li.getResource().getPrefixedName();
        TileLayer tl = tld.getTileLayer(layerName);
        GWCCatalogListenerTest.assertEquals((String)layerName, (String)tl.getName());
        cat.remove(li);
        GWCCatalogListenerTest.assertTrue((cat.getLayerByName(tl.getName()) == null ? 1 : 0) != 0);
        boolean caughtException = false;
        try {
            TileLayer tl2 = tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException gwce) {
            caughtException = true;
        }
        GWCCatalogListenerTest.assertTrue((boolean)caughtException);
        ResourceInfo resInfo = li.getResource();
        resInfo.setName("hithere");
        resInfo.getNamespace().setPrefix("sf");
        LayerInfo layerInfo = cat.getFactory().createLayer();
        layerInfo.setResource(resInfo);
        layerInfo.setName(resInfo.getPrefixedName());
        cat.add(layerInfo);
        String newLayerName = layerInfo.getName();
        TileLayer tl3 = tld.getTileLayer(newLayerName);
        GWCCatalogListenerTest.assertEquals((String)newLayerName, (String)tl3.getName());
        LayerGroupInfo lgi = cat.getFactory().createLayerGroup();
        lgi.setName("sf:aLayerGroup");
        lgi.setBounds(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, CRS.decode((String)"EPSG:4326")));
        lgi.getLayers().add(cat.getLayerByName("hithere"));
        cat.add(lgi);
        TileLayer tl4 = tld.getTileLayer("sf:aLayerGroup");
        GWCCatalogListenerTest.assertNotNull((Object)tl4);
        GWCCatalogListenerTest.assertEquals((String)lgi.getName(), (String)tl4.getName());
    }
}

