/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.net.URL;
import junit.framework.TestCase;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.impl.GeoServerFactoryImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geotools.data.DataUtilities;

public class LegacyConfigurationImporterTest
extends TestCase {
    LegacyConfigurationImporter importer;

    protected void setUp() throws Exception {
        GeoServerImpl gs = new GeoServerImpl();
        gs.setFactory((GeoServerFactory)new GeoServerFactoryImpl((GeoServer)gs));
        this.importer = new LegacyConfigurationImporter((GeoServer)gs);
        this.importer.imprt(DataUtilities.urlToFile((URL)((Object)((Object)this)).getClass().getResource("services.xml")).getParentFile());
    }

    public void testGlobal() throws Exception {
        GeoServerInfo info = this.importer.getConfiguration().getGlobal();
        LegacyConfigurationImporterTest.assertNotNull((Object)info);
        LoggingInfo logging = this.importer.getConfiguration().getLogging();
        LegacyConfigurationImporterTest.assertNotNull((Object)logging);
        LegacyConfigurationImporterTest.assertEquals((String)"DEFAULT_LOGGING.properties", (String)logging.getLevel());
        LegacyConfigurationImporterTest.assertTrue((boolean)logging.isStdOutLogging());
        LegacyConfigurationImporterTest.assertEquals((String)"logs/geoserver.log", (String)logging.getLocation());
        LegacyConfigurationImporterTest.assertFalse((boolean)info.isVerbose());
        LegacyConfigurationImporterTest.assertFalse((boolean)info.isVerboseExceptions());
        LegacyConfigurationImporterTest.assertEquals((int)8, (int)info.getNumDecimals());
        LegacyConfigurationImporterTest.assertEquals((String)"UTF-8", (String)info.getCharset());
        LegacyConfigurationImporterTest.assertEquals((long)3L, (long)info.getUpdateSequence());
    }
}

