/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.util.logging.Logging;

public class CascadeDeleteVisitor
implements CatalogVisitor {
    static final Logger LOGGER = Logging.getLogger(CascadeDeleteVisitor.class);
    Catalog catalog;

    public CascadeDeleteVisitor(Catalog catalog) {
        this.catalog = catalog;
    }

    public void visit(Catalog catalog) {
    }

    public void visit(WorkspaceInfo workspace) {
        for (StoreInfo s : this.catalog.getStoresByWorkspace(workspace, StoreInfo.class)) {
            s.accept(this);
        }
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (ns != null) {
            ns.accept(this);
        }
        this.catalog.remove(workspace);
    }

    public void visit(NamespaceInfo workspace) {
        this.catalog.remove(workspace);
    }

    void visitStore(StoreInfo store) {
        List<ResourceInfo> resources = this.catalog.getResourcesByStore(store, ResourceInfo.class);
        for (ResourceInfo ri : resources) {
            List<LayerInfo> layers = this.catalog.getLayers(ri);
            for (LayerInfo li : layers) {
                li.accept(this);
            }
        }
        this.catalog.remove(store);
    }

    public void visit(DataStoreInfo dataStore) {
        this.visitStore(dataStore);
    }

    public void visit(CoverageStoreInfo coverageStore) {
        this.visitStore(coverageStore);
    }

    public void visit(WMSStoreInfo wmsStore) {
        this.visitStore(wmsStore);
    }

    public void visit(FeatureTypeInfo featureType) {
        this.catalog.remove(featureType);
    }

    public void visit(CoverageInfo coverage) {
        this.catalog.remove(coverage);
    }

    public void visit(LayerInfo layer) {
        for (LayerGroupInfo group : this.catalog.getLayerGroups()) {
            if (!group.getLayers().contains(layer)) continue;
            int index = group.getLayers().indexOf(layer);
            group.getLayers().remove(index);
            group.getStyles().remove(index);
            if (group.getLayers().size() == 0) {
                this.catalog.remove(group);
                continue;
            }
            this.catalog.save(group);
        }
        ResourceInfo resource = layer.getResource();
        this.catalog.remove(layer);
        this.catalog.remove(resource);
    }

    public void visit(StyleInfo style) {
        List<LayerInfo> layer = this.catalog.getLayers();
        for (LayerInfo li : layer) {
            if (li.getDefaultStyle().equals(style)) {
                try {
                    li.setDefaultStyle(new CatalogBuilder(this.catalog).getDefaultStyle(li.getResource()));
                    this.catalog.save(li);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not find default style for resource " + li.getResource() + " resetting the default to null");
                    li.setDefaultStyle(null);
                }
            }
            if (!li.getStyles().remove(style)) continue;
            this.catalog.save(li);
        }
        List<LayerGroupInfo> groups = this.catalog.getLayerGroups();
        for (LayerGroupInfo group : groups) {
            List<StyleInfo> styles = group.getStyles();
            boolean dirty = false;
            int i = 0;
            while (i < styles.size()) {
                StyleInfo si = styles.get(i);
                if (si != null && si.equals(style)) {
                    styles.set(i, group.getLayers().get(i).getDefaultStyle());
                    dirty = true;
                }
                ++i;
            }
            if (!dirty) continue;
            this.catalog.save(group);
        }
        this.catalog.remove(style);
    }

    public void visit(LayerGroupInfo layerGroup) {
        this.catalog.remove(layerGroup);
    }

    public void visit(WMSLayerInfo wmsLayer) {
        this.catalog.remove(wmsLayer);
    }
}

