/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureLocking;
import org.geoserver.security.decorators.SecurityUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLocking;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredSimpleFeatureLocking
extends SecuredFeatureLocking<SimpleFeatureType, SimpleFeature>
implements SimpleFeatureLocking {
    protected SecuredSimpleFeatureLocking(FeatureLocking delegate, WrapperPolicy policy) {
        super(delegate, policy);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return DataUtilities.simple(super.getFeatures());
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return DataUtilities.simple(super.getFeatures(filter));
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return DataUtilities.simple(super.getFeatures(query));
    }

    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new String[]{name}, new Object[]{attributeValue}, filter);
    }

    public void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery == Query.ALL) {
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, filter);
        } else if (writeQuery.getFilter() == Filter.EXCLUDE || writeQuery.getPropertyNames() == Query.NO_NAMES) {
            throw this.unsupportedOperation();
        }
        Query local = new Query(null, filter);
        Query mixed = DataUtilities.mixQueries((Query)local, (Query)writeQuery, null);
        if (writeQuery.getPropertyNames() == Query.ALL_NAMES) {
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, mixed.getFilter());
        } else {
            HashSet<String> queryNames = new HashSet<String>(Arrays.asList(writeQuery.getPropertyNames()));
            int i = 0;
            while (i < names.length) {
                if (!queryNames.contains(names[i])) {
                    String typeName = ((SimpleFeatureType)this.getSchema()).getName().getLocalPart();
                    if (this.policy.getResponse() == Response.CHALLENGE) {
                        throw SecureCatalogImpl.unauthorizedAccess(typeName);
                    }
                    throw new UnsupportedOperationException("Trying to write on the write protected attribute " + names[i]);
                }
                ++i;
            }
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, mixed.getFilter());
        }
    }
}

