/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.vividsolutions.jts.geom.Envelope;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CascadeDeleteVisitorTest
extends GeoServerTestSupport {
    static final String LAKES_GROUP = "lakesGroup";
    CascadeDeleteVisitor visitor;
    Catalog catalog;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.catalog = this.getCatalog();
        this.visitor = new CascadeDeleteVisitor(this.catalog);
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        String forests = MockData.FORESTS.getLocalPart();
        String bridges = MockData.BRIDGES.getLocalPart();
        this.setNativeBox(catalog, lakes);
        this.setNativeBox(catalog, forests);
        this.setNativeBox(catalog, bridges);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName(LAKES_GROUP);
        lg.getLayers().add(catalog.getLayerByName(lakes));
        lg.getStyles().add(catalog.getStyleByName(lakes));
        lg.getLayers().add(catalog.getLayerByName(forests));
        lg.getStyles().add(catalog.getStyleByName(forests));
        lg.getLayers().add(catalog.getLayerByName(bridges));
        lg.getStyles().add(catalog.getStyleByName(bridges));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }

    public void setNativeBox(Catalog catalog, String name) throws Exception {
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(name);
        fti.setNativeBoundingBox(fti.getFeatureSource(null, null).getBounds());
        fti.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)fti.getNativeBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        catalog.save((ResourceInfo)fti);
    }

    public void testCascadeLayer() {
        String name = this.getLayerId(MockData.LAKES);
        LayerInfo layer = this.catalog.getLayerByName(name);
        CascadeDeleteVisitorTest.assertNotNull((Object)layer);
        layer.accept((CatalogVisitor)this.visitor);
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getLayerByName(name));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getResourceByName(name, ResourceInfo.class));
        LayerGroupInfo group = this.catalog.getLayerGroupByName(LAKES_GROUP);
        CascadeDeleteVisitorTest.assertEquals((int)2, (int)group.getLayers().size());
        CascadeDeleteVisitorTest.assertFalse((boolean)group.getLayers().contains(layer));
    }

    public void testCascadeStore() {
        String citeStore = MockData.CITE_PREFIX;
        StoreInfo store = this.catalog.getStoreByName(citeStore, StoreInfo.class);
        String buildings = this.getLayerId(MockData.BUILDINGS);
        String lakes = this.getLayerId(MockData.LAKES);
        CascadeDeleteVisitorTest.assertNotNull((Object)store);
        CascadeDeleteVisitorTest.assertNotNull((Object)this.catalog.getLayerByName(buildings));
        CascadeDeleteVisitorTest.assertNotNull((Object)this.catalog.getResourceByName(buildings, ResourceInfo.class));
        CascadeDeleteVisitorTest.assertNotNull((Object)this.catalog.getLayerByName(lakes));
        CascadeDeleteVisitorTest.assertNotNull((Object)this.catalog.getResourceByName(lakes, ResourceInfo.class));
        CascadeDeleteVisitorTest.assertNotNull((Object)this.catalog.getLayerGroupByName(LAKES_GROUP));
        store.accept((CatalogVisitor)this.visitor);
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getStoreByName(citeStore, StoreInfo.class));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getLayerByName(buildings));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getResourceByName(buildings, ResourceInfo.class));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getLayerByName(lakes));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getResourceByName(lakes, ResourceInfo.class));
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getLayerGroupByName(LAKES_GROUP));
    }

    public void testCascadeWorkspace() {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        CascadeDeleteVisitorTest.assertNotNull((Object)ws);
        CascadeDeleteVisitorTest.assertTrue((this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class).size() > 0 ? 1 : 0) != 0);
        ws.accept((CatalogVisitor)this.visitor);
        CascadeDeleteVisitorTest.assertEquals((int)0, (int)this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class).size());
    }

    public void testCascadeStyle() {
        String styleName = MockData.LAKES.getLocalPart();
        String layerName = this.getLayerId(MockData.LAKES);
        StyleInfo style = this.catalog.getStyleByName(styleName);
        CascadeDeleteVisitorTest.assertNotNull((Object)style);
        LayerInfo buildings = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        buildings.getStyles().add(style);
        this.catalog.save(buildings);
        buildings = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        CascadeDeleteVisitorTest.assertTrue((boolean)buildings.getStyles().contains(style));
        style.accept((CatalogVisitor)this.visitor);
        CascadeDeleteVisitorTest.assertNull((Object)this.catalog.getStyleByName(styleName));
        CascadeDeleteVisitorTest.assertEquals((String)"polygon", (String)this.catalog.getLayerByName(layerName).getDefaultStyle().getName());
        buildings = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        CascadeDeleteVisitorTest.assertFalse((boolean)buildings.getStyles().contains(style));
    }
}

