/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.ArrayList;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.springframework.security.SpringSecurityException;

public class SecuredFeatureCollectionTest
extends SecureObjectsTest {
    private FeatureCollection fc;
    private Feature feature;
    private SortBy sort;

    protected void setUp() throws Exception {
        super.setUp();
        this.feature = (Feature)EasyMock.createNiceMock(Feature.class);
        EasyMock.replay((Object[])new Object[]{this.feature});
        Iterator it = (Iterator)EasyMock.createNiceMock(Iterator.class);
        EasyMock.replay((Object[])new Object[]{it});
        this.sort = (SortBy)EasyMock.createNiceMock(SortBy.class);
        EasyMock.replay((Object[])new Object[]{this.sort});
        SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)schema.getTypeName()).andReturn((Object)"testSchema").anyTimes();
        EasyMock.replay((Object[])new Object[]{schema});
        this.fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)this.fc.iterator()).andReturn((Object)it).anyTimes();
        EasyMock.expect((Object)this.fc.sort(this.sort)).andReturn((Object)this.fc).anyTimes();
        EasyMock.expect((Object)this.fc.subCollection((Filter)Filter.INCLUDE)).andReturn((Object)this.fc).anyTimes();
        EasyMock.expect((Object)this.fc.getSchema()).andReturn((Object)schema).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.fc});
    }

    public void testHide() throws Exception {
        SecuredFeatureCollection ro = new SecuredFeatureCollection(this.fc, WrapperPolicy.hide(null));
        try {
            ro.add(this.feature);
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.addAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.clear();
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.remove((Object)this.feature);
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.removeAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.retainAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator roit = ro.iterator();
        roit.hasNext();
        roit.next();
        try {
            roit.remove();
            SecuredFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SecuredFeatureCollection sorted = (SecuredFeatureCollection)ro.sort(this.sort);
        SecuredFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
        SecuredFeatureCollection sub = (SecuredFeatureCollection)ro.subCollection((Filter)Filter.INCLUDE);
        SecuredFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }

    public void testChallenge() throws Exception {
        SecuredFeatureCollection ro = new SecuredFeatureCollection(this.fc, WrapperPolicy.readOnlyChallenge(null));
        try {
            ro.add(this.feature);
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.addAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.clear();
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.remove((Object)this.feature);
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.removeAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.retainAll(new ArrayList());
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator roit = ro.iterator();
        roit.hasNext();
        roit.next();
        try {
            roit.remove();
            SecuredFeatureCollectionTest.fail((String)"Should have failed with a spring security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        SecuredFeatureCollection sorted = (SecuredFeatureCollection)ro.sort(this.sort);
        SecuredFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
        SecuredFeatureCollection sub = (SecuredFeatureCollection)ro.subCollection((Filter)Filter.INCLUDE);
        SecuredFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }
}

