/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyCatalogReader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    Element catalog;

    public void read(File file) throws IOException {
        Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));
        try {
            this.catalog = ReaderUtils.parse(reader);
        }
        finally {
            reader.close();
        }
    }

    public Map<String, Map<String, Object>> dataStores() throws Exception {
        Element dataStoresElement = ReaderUtils.getChildElement(this.catalog, "datastores", true);
        NodeList dataStoreElements = dataStoresElement.getElementsByTagName("datastore");
        LinkedHashMap<String, Map<String, Object>> dataStores = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        while (i < dataStoreElements.getLength()) {
            block3: {
                Element dataStoreElement = (Element)dataStoreElements.item(i);
                HashMap<String, Object> dataStore = new HashMap<String, Object>();
                String id = ReaderUtils.getAttribute(dataStoreElement, "id", true);
                dataStore.put("id", id);
                dataStore.put("namespace", ReaderUtils.getAttribute(dataStoreElement, "namespace", false));
                dataStore.put("enabled", ReaderUtils.getBooleanAttribute(dataStoreElement, "enabled", false, true));
                try {
                    Map params = this.dataStoreParams(dataStoreElement);
                    dataStore.put("connectionParams", params);
                }
                catch (Exception e) {
                    LOGGER.warning("Error reading data store paramaters: " + e.getMessage());
                    LOGGER.log(Level.INFO, "", e);
                    break block3;
                }
                dataStores.put(id, dataStore);
            }
            ++i;
        }
        return dataStores;
    }

    public List<Map<String, Object>> formats() throws Exception {
        Element formatsElement = ReaderUtils.getChildElement(this.catalog, "formats", true);
        NodeList formatElements = formatsElement.getElementsByTagName("format");
        ArrayList<Map<String, Object>> formats = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < formatElements.getLength()) {
            Element formatElement = (Element)formatElements.item(i);
            HashMap<String, Object> format = new HashMap<String, Object>();
            format.put("id", ReaderUtils.getAttribute(formatElement, "id", true));
            format.put("namespace", ReaderUtils.getAttribute(formatElement, "namespace", false));
            format.put("enabled", ReaderUtils.getBooleanAttribute(formatElement, "enabled", false, true));
            format.put("type", ReaderUtils.getChildText(formatElement, "type", true));
            format.put("url", ReaderUtils.getChildText(formatElement, "url", false));
            format.put("title", ReaderUtils.getChildText(formatElement, "title", false));
            format.put("description", ReaderUtils.getChildText(formatElement, "description", false));
            formats.add(format);
            ++i;
        }
        return formats;
    }

    public Map<String, String> namespaces() throws Exception {
        Element namespacesElement = ReaderUtils.getChildElement(this.catalog, "namespaces", true);
        NodeList namespaceElements = namespacesElement.getElementsByTagName("namespace");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        int i = 0;
        while (i < namespaceElements.getLength()) {
            Element namespaceElement = (Element)namespaceElements.item(i);
            try {
                Map.Entry tuple = this.namespaceTuple(namespaceElement);
                namespaces.put((String)tuple.getKey(), (String)tuple.getValue());
                if ("true".equals(namespaceElement.getAttribute("default"))) {
                    namespaces.put("", (String)tuple.getValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return namespaces;
    }

    public Map<String, String> styles() throws Exception {
        Element stylesElement = ReaderUtils.getChildElement(this.catalog, "styles", true);
        NodeList styleElements = stylesElement.getElementsByTagName("style");
        HashMap<String, String> styles = new HashMap<String, String>();
        int i = 0;
        while (i < styleElements.getLength()) {
            Element styleElement = (Element)styleElements.item(i);
            styles.put(styleElement.getAttribute("id"), styleElement.getAttribute("filename"));
            ++i;
        }
        return styles;
    }

    protected Map dataStoreParams(Element dataStoreElement) throws Exception {
        Element paramsElement = ReaderUtils.getChildElement(dataStoreElement, "connectionParams", true);
        NodeList paramList = paramsElement.getElementsByTagName("parameter");
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < paramList.getLength()) {
            Element paramElement = (Element)paramList.item(i);
            String key = ReaderUtils.getAttribute(paramElement, "name", true);
            String value = ReaderUtils.getAttribute(paramElement, "value", false);
            params.put(key, value);
            ++i;
        }
        return params;
    }

    protected Map.Entry namespaceTuple(Element namespaceElement) throws Exception {
        final String pre = namespaceElement.getAttribute("prefix");
        final String uri = namespaceElement.getAttribute("uri");
        return new Map.Entry(){

            public Object getKey() {
                return pre;
            }

            public Object getValue() {
                return uri;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

