/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.geoserver.config.GeoServerDataDirectory;

public class GeoServerDataSource
extends BasicDataSource {
    GeoServerDataDirectory dataDirectory;
    String file;
    Properties defaultParameters;

    public void setDataDirectory(GeoServerDataDirectory dataDir) {
        this.dataDirectory = dataDir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setDefaultParameters(Properties defaultParameters) {
        this.defaultParameters = defaultParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.getDriverClassName() == null) {
            GeoServerDataSource geoServerDataSource = this;
            synchronized (geoServerDataSource) {
                if (this.getDriverClassName() == null) {
                    this.initializeDataSource();
                }
            }
        }
        return super.getConnection();
    }

    void initializeDataSource() {
        try {
            File dbprops = new File(this.dataDirectory.root(), this.file);
            Properties db = new Properties();
            if (!dbprops.exists()) {
                if (dbprops.getParentFile().exists()) {
                    dbprops.getParentFile().mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(dbprops);
                try {
                    this.defaultParameters.store(fout, null);
                }
                finally {
                    fout.close();
                }
                db.putAll((Map<?, ?>)this.defaultParameters);
            } else {
                FileInputStream in = new FileInputStream(dbprops);
                db.load(in);
                in.close();
            }
            this.setDriverClassName(db.getProperty("driver"));
            this.setUrl(this.getURL(db));
            if (db.containsKey("username")) {
                this.setUsername(db.getProperty("username"));
            }
            if (db.containsKey("password")) {
                this.setPassword(db.getProperty("password"));
            }
            this.setMinIdle(1);
            this.setMaxActive(4);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error setting up the datas source", e);
        }
    }

    String getURL(Properties db) {
        return db.getProperty("url").replace("%GEOSERVER_DATA_DIR%", this.dataDirectory.root().getAbsolutePath());
    }
}

