/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.logging.Logger;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;

public class WMSLayerTest
extends CatalogRESTTestSupport {
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.setWorkspace(this.catalog.getWorkspaceByName("sf"));
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?");
        this.catalog.add((StoreInfo)wms);
        WMSLayerInfo wml = this.catalog.getFactory().createWMSLayer();
        wml.setName("states");
        wml.setNativeName("topp:states");
        wml.setStore(this.catalog.getStoreByName("demo", WMSStoreInfo.class));
        wml.setCatalog(this.catalog);
        wml.setNamespace(this.catalog.getNamespaceByPrefix("sf"));
        wml.setSRS("EPSG:4326");
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
        wml.setNativeCRS(wgs84);
        wml.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
        wml.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        this.catalog.add((ResourceInfo)wml);
    }

    public void testGetAllByWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmslayers.xml");
        WMSLayerTest.assertEquals((int)this.catalog.getResourcesByNamespace(this.catalog.getNamespaceByPrefix("sf"), WMSLayerInfo.class).size(), (int)dom.getElementsByTagName("wmsLayer").getLength());
    }

    public void testGetAllByWMSStore() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo/wmslayers.xml");
        WMSLayerTest.assertEquals((int)1, (int)dom.getElementsByTagName("wmsLayer").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wmsLayer/name[text()='states'])", (Document)dom);
    }

    public void testGetAllAvailable() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.warning("Skipping layer availability test as remote server is not available");
            return;
        }
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo/wmslayers.xml?list=available");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"count(//wmsLayerName) > 0", (Document)dom);
    }

    public void testPutAllUnauthorized() throws Exception {
        WMSLayerTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        WMSLayerTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers").getStatusCode());
    }

    public void testPostAsXML() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.warning("Skipping layer posting test as remote server is not available");
            return;
        }
        WMSLayerTest.assertNull((Object)this.catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class));
        String xml = "<wmsLayer><name>bugsites</name><nativeName>og:bugsites</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><store>demo</store></wmsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/", xml, "text/xml");
        WMSLayerTest.assertEquals((int)201, (int)response.getStatusCode());
        WMSLayerTest.assertNotNull((Object)response.getHeader("Location"));
        WMSLayerTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmsstores/demo/wmslayers/bugsites"));
        WMSLayerInfo layer = (WMSLayerInfo)this.catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class);
        WMSLayerTest.assertNotNull((Object)layer.getNativeBoundingBox());
    }

    public void testPostAsJSON() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.warning("Skipping layer posting test as remote server is not available");
            return;
        }
        WMSLayerTest.assertNull((Object)this.catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class));
        String json = "{'wmsLayer':{'name':'bugsites','nativeName':'og:bugsites','srs':'EPSG:4326','nativeCRS':'EPSG:4326','store':'demo'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/", json, "text/json");
        WMSLayerTest.assertEquals((int)201, (int)response.getStatusCode());
        WMSLayerTest.assertNotNull((Object)response.getHeader("Location"));
        WMSLayerTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmsstores/demo/wmslayers/bugsites"));
        WMSLayerInfo layer = (WMSLayerInfo)this.catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class);
        WMSLayerTest.assertNotNull((Object)layer.getNativeBoundingBox());
    }

    public void testPostToResource() throws Exception {
        String xml = "<wmsLayer><name>og:restricted</name></wmsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states", xml, "text/xml");
        WMSLayerTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmslayers/states.xml");
        WMSLayerTest.assertEquals((String)"wmsLayer", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"states", (String)"/wmsLayer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"/wmsLayer/srs", (Document)dom);
        WMSLayerTest.assertEquals((String)CRS.decode((String)"EPSG:4326").toWKT(), (String)this.xp.evaluate("/wmsLayer/nativeCRS", dom));
        WMSLayerInfo wml = (WMSLayerInfo)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        ReferencedEnvelope re = wml.getLatLonBoundingBox();
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinX() + ""), (String)"/wmsLayer/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxX() + ""), (String)"/wmsLayer/latLonBoundingBox/maxx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinY() + ""), (String)"/wmsLayer/latLonBoundingBox/miny", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxY() + ""), (String)"/wmsLayer/latLonBoundingBox/maxy", (Document)dom);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmslayers/states.json");
        JSONObject featureType = ((JSONObject)json).getJSONObject("wmsLayer");
        WMSLayerTest.assertNotNull((Object)featureType);
        WMSLayerTest.assertEquals((Object)"states", (Object)featureType.get("name"));
        WMSLayerTest.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)featureType.get("nativeCRS"));
        WMSLayerTest.assertEquals((Object)"EPSG:4326", (Object)featureType.get("srs"));
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmslayers/states.html");
    }

    public void testPut() throws Exception {
        String xml = "<wmsLayer><title>Lots of states here</title></wmsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states", xml, "text/xml");
        WMSLayerTest.assertEquals((int)200, (int)response.getStatusCode());
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo/wmslayers/states.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"Lots of states here", (String)"/wmsLayer/title", (Document)dom);
        WMSLayerInfo wli = (WMSLayerInfo)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        WMSLayerTest.assertEquals((String)"Lots of states here", (String)wli.getTitle());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<wmsLayer><title>new title</title></wmsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/bugsites", xml, "text/xml");
        WMSLayerTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDelete() throws Exception {
        WMSLayerTest.assertNotNull((Object)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        WMSLayerTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states").getStatusCode());
        WMSLayerTest.assertNull((Object)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
    }

    public void testDeleteNonExistant() throws Exception {
        WMSLayerTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/NonExistent").getStatusCode());
    }

    void addLayer() {
        LayerInfo l = this.catalog.getFactory().createLayer();
        l.setResource(this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        this.catalog.add(l);
    }

    public void testDeleteNonRecursive() throws Exception {
        this.addLayer();
        WMSLayerTest.assertNotNull((Object)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        WMSLayerTest.assertEquals((int)403, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        this.addLayer();
        WMSLayerTest.assertNotNull((Object)this.catalog.getLayerByName("sf:states"));
        WMSLayerTest.assertNotNull((Object)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        WMSLayerTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states?recurse=true").getStatusCode());
        WMSLayerTest.assertNull((Object)this.catalog.getLayerByName("sf:states"));
        WMSLayerTest.assertNull((Object)this.catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
    }
}

