/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.rest.RestletException;
import org.geotools.util.logging.Logging;
import org.restlet.Finder;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class CatalogReloader
extends Finder {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");
    GeoServer geoServer;

    public CatalogReloader(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public Resource findTarget(Request request, Response response) {
        if (request.getMethod() != Method.POST && request.getMethod() != Method.PUT) {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            return null;
        }
        return new Resource(){

            public boolean allowPost() {
                return true;
            }

            public boolean allowPut() {
                return true;
            }

            public void handlePost() {
                try {
                    CatalogReloader.this.reloadCatalog();
                }
                catch (Exception e) {
                    throw new RestletException("Error reloading catalog", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
                }
            }

            public void handlePut() {
                this.handlePost();
            }
        };
    }

    protected void reloadCatalog() throws Exception {
        this.geoServer.reload();
    }
}

