/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.CoverageStoreResource;
import org.geoserver.catalog.rest.StoreFileResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.opengis.coverage.grid.Format;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class CoverageStoreFileResource
extends StoreFileResource {
    Format coverageFormat;

    public CoverageStoreFileResource(Request request, Response response, Format coverageFormat, Catalog catalog) {
        super(request, response, catalog);
        this.coverageFormat = coverageFormat;
    }

    public void handlePut() {
        Request request = this.getRequest();
        Response response = this.getResponse();
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String format = this.getAttribute("format");
        String method = this.getUploadMethod(request);
        File uploadedFile = this.doFileUpload(method, workspace, coveragestore, format);
        Form form = request.getResourceRef().getQueryAsForm();
        if ("yes".equalsIgnoreCase(form.getFirstValue("overviews"))) {
            // empty if block
        }
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        builder.setWorkspace(this.catalog.getWorkspaceByName(workspace));
        CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        boolean add = false;
        if (info == null) {
            LOGGER.info("Auto-configuring coverage store: " + coveragestore);
            info = builder.buildCoverageStore(coveragestore);
            add = true;
        } else {
            LOGGER.info("Using existing coverage store: " + coveragestore);
        }
        info.setType(this.coverageFormat.getName());
        if (this.isInlineUpload(method)) {
            info.setURL("file:data/" + workspace + "/" + coveragestore + "/" + uploadedFile.getName());
        } else {
            try {
                info.setURL(uploadedFile.toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                throw new RestletException("url error", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        if (add) {
            this.catalog.add((StoreInfo)info);
        } else {
            this.catalog.save((StoreInfo)info);
        }
        builder.setStore((StoreInfo)info);
        String configure = form.getFirstValue("configure");
        if ("none".equalsIgnoreCase(configure)) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
            return;
        }
        String coverage = uploadedFile.getName();
        if (coverage.indexOf(46) != -1) {
            coverage = coverage.substring(0, coverage.indexOf(46));
        }
        try {
            AbstractGridCoverage2DReader reader = ((AbstractGridFormat)this.coverageFormat).getReader((Object)uploadedFile.toURL());
            if (reader == null) {
                throw new RestletException("Could not aquire reader for coverage.", Status.SERVER_ERROR_INTERNAL);
            }
            HashMap<String, Boolean> customParameters = new HashMap<String, Boolean>();
            String useJAIImageReadParam = form.getFirstValue("USE_JAI_IMAGEREAD");
            if (useJAIImageReadParam != null) {
                customParameters.put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().toString(), Boolean.valueOf(useJAIImageReadParam));
            }
            CoverageInfo cinfo = builder.buildCoverage(reader, customParameters);
            String coverageName = form.getFirstValue("coverageName");
            if (coverageName != null) {
                cinfo.setName(coverageName);
            }
            if (!add) {
                CoverageInfo existing = this.catalog.getCoverageByCoverageStore(info, coverageName != null ? coverageName : coverage);
                if (existing == null) {
                    List coverages = this.catalog.getCoveragesByCoverageStore(info);
                    if (coverages.size() == 1) {
                        existing = (CoverageInfo)coverages.get(0);
                    }
                    if (coverages.size() == 0) {
                        add = true;
                    } else {
                        throw new RestletException("Unable to determine coverage to configure.", Status.SERVER_ERROR_INTERNAL);
                    }
                }
                if (existing != null) {
                    builder.updateCoverage(existing, cinfo);
                    this.catalog.save((ResourceInfo)existing);
                    cinfo = existing;
                }
            }
            if ("UNKNOWN".equals(cinfo.getSRS())) {
                cinfo.setSRS("EPSG:4326");
            }
            if (add) {
                this.catalog.add((ResourceInfo)cinfo);
                LayerInfo layerInfo = builder.buildLayer(cinfo);
                boolean valid = true;
                try {
                    if (!this.catalog.validate(layerInfo, true).isEmpty()) {
                        valid = false;
                    }
                }
                catch (Exception e) {
                    valid = false;
                }
                layerInfo.setEnabled(valid);
                this.catalog.add(layerInfo);
            } else {
                this.catalog.save((ResourceInfo)cinfo);
            }
            ReflectiveXMLFormat df = new CoverageStoreResource(this.getContext(), request, response, this.catalog).createXMLFormat(request, response);
            response.setEntity(df.toRepresentation((Object)info));
            response.setStatus(Status.SUCCESS_CREATED);
        }
        catch (Exception e) {
            throw new RestletException("Error auto-configuring coverage", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    protected File findPrimaryFile(File directory, String format) {
        for (File f : directory.listFiles()) {
            if (!((AbstractGridFormat)this.coverageFormat).accepts((Object)f)) continue;
            return f;
        }
        return null;
    }
}

